<?php
/**
 * Theme Default Footer
 * @package foresty
 * @since 1.0.0
 */

$copyright_text = !empty(cs_get_option('copyright_text')) ? cs_get_option('copyright_text'): esc_html__('© 2023 . All Rights Reserved Foresty','foresty');
$copyright_text = str_replace('{copy}','&copy;',$copyright_text);
$copyright_text = str_replace('{year}',date('Y'),$copyright_text);
?>
<div class="footer-style">
    <footer class="footer-wrap">
        <?php get_template_part('template-parts/content/footer-widget'); ?>
        <div class="copyright-wrap">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 text-center">
                        <div class="copyright-content">
                            <p class="copyright-text mb-0">
                                <?php
                                    echo wp_kses($copyright_text, foresty()->kses_allowed_html(array('a')));
                                ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
