<?php
/**
 * Theme Options
 * @package foresty
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {

    $allowed_html = foresty()->kses_allowed_html(array('mark'));
    $prefix = 'foresty';
    // Create options
    CSF::createOptions($prefix . '_theme_options', array(
        'menu_title' => esc_html__('Theme Options', 'foresty'),
        'menu_slug' => 'foresty_theme_options',
        'menu_parent' => 'foresty_theme_options',
        'menu_type' => 'submenu',
        'footer_credit' => ' ',
        'menu_icon' => 'fa fa-filter',
        'show_footer' => false,
        'enqueue_webfont' => false,
        'show_search' => true,
        'show_reset_all' => true,
        'show_reset_section' => true,
        'show_all_options' => false,
        'theme' => 'dark',
        'framework_title' => foresty()->get_theme_info('name')
    ));

    /*-------------------------------------------------------
        ** General  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('General', 'foresty'),
        'id' => 'general_options',
        'icon' => 'fas fa-cogs',
    ));
    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Preloader & SVG Enable', 'foresty'),
        'id' => 'theme_general_preloader_options',
        'icon' => 'fa fa-spinner',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Preloader Options', 'foresty') . '</h3>'
            ),
            array(
                'id' => 'preloader_enable',
                'title' => esc_html__('Preloader', 'foresty'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable preloader', 'foresty'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'preloader_bg_color',
                'title' => esc_html__('Background Color', 'foresty'),
                'type' => 'color',
                'desc' => wp_kses(__('you can set <mark>overlay color</mark> for preloader background image', 'foresty'), $allowed_html),
                'dependency' => array('preloader_enable', '==', 'true')
            ),
            array(
                'id' => 'enable_svg_upload',
                'type' => 'switcher',
                'title' => esc_html__('Enable Svg Upload ?', 'foresty'),
                'desc' => esc_html__('If you want to enable or disable svg upload you can set ( YES / NO )', 'foresty'),
                'default' => false,
            ),
        )
    ));

    /*-------------------------------------------------------
           ** Typography  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'typography',
        'title' => esc_html__('Typography', 'foresty'),
        'icon' => 'fas fa-text-height',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Body Font Options', 'foresty') . '</h3>',
            ),
            array(
                'type' => 'typography',
                'title' => esc_html__('Typography', 'foresty'),
                'id' => '_body_font',
                'default' => array(
                    'font-family' => 'Inter',
                    'font-size' => '16',
                    'line-height' => '26',
                    'unit' => 'px',
                    'type' => 'google',
                ),
                'color' => false,
                'subset' => false,
                'text_align' => false,
                'text_transform' => false,
                'letter_spacing' => false,
                'line_height' => false,
                'desc' => wp_kses(__('you can set <mark>font</mark> for all html tags (if not use different heading font)', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'body_font_variant',
                'type' => 'select',
                'title' => esc_html__('Load Font Variant', 'foresty'),
                'multiple' => true,
                'chosen' => true,
                'options' => array(
                    '300' => esc_html__('Light 300', 'foresty'),
                    '400' => esc_html__('Regular 400', 'foresty'),
                    '500' => esc_html__('Medium 500', 'foresty'),
                    '600' => esc_html__('Semi Bold 600', 'foresty'),
                    '700' => esc_html__('Bold 700', 'foresty'),
                    '800' => esc_html__('Extra Bold 800', 'foresty'),
                ),
                'default' => array('400', '500', '600', '700')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading Font Options', 'foresty') . '</h3>',
            ),
            array(
                'type' => 'switcher',
                'id' => 'heading_font_enable',
                'title' => esc_html__('Heading Font', 'foresty'),
                'desc' => wp_kses(__('you can set <mark>yes</mark> to select different heading font', 'foresty'), $allowed_html),
                'default' => true
            ),
            array(
                'type' => 'typography',
                'title' => esc_html__('Typography', 'foresty'),
                'id' => 'heading_font',
                'default' => array(
                    'font-family' => 'Inter',
                    'type' => 'google',
                ),
                'color' => false,
                'subset' => false,
                'text_align' => false,
                'text_transform' => false,
                'letter_spacing' => false,
                'font_size' => false,
                'line_height' => false,
                'desc' => wp_kses(__('you can set <mark>font</mark> for  for heading tag .eg: h1,h2mh3,h4,h5,h6', 'foresty'), $allowed_html),
                'dependency' => array('heading_font_enable', '==', 'true')
            ),
            array(
                'id' => 'heading_font_variant',
                'type' => 'select',
                'title' => esc_html__('Load Font Variant', 'foresty'),
                'multiple' => true,
                'chosen' => true,
                'options' => array(
                    '300' => esc_html__('Light 300', 'foresty'),
                    '400' => esc_html__('Regular 400', 'foresty'),
                    '500' => esc_html__('Medium 500', 'foresty'),
                    '600' => esc_html__('Semi Bold 600', 'foresty'),
                    '700' => esc_html__('Bold 700', 'foresty'),
                    '800' => esc_html__('Extra Bold 800', 'foresty'),
                ),
                'default' => array('400', '500', '600', '700'),
                'dependency' => array('heading_font_enable', '==', 'true')
            ),
        )
    ));

    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Back To Top', 'foresty'),
        'id' => 'theme_general_back_top_options',
        'icon' => 'fa fa-arrow-up',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Back Top Options', 'foresty') . '</h3>'
            ),
            array(
                'id' => 'back_top_enable',
                'title' => esc_html__('Back Top', 'foresty'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide back to top', 'foresty'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'back_top_icon',
                'title' => esc_html__('Back Top Icon', 'foresty'),
                'type' => 'icon',
                'default' => 'fa fa-angle-up',
                'desc' => wp_kses(__('you can set <mark>icon</mark> for back to top.', 'foresty'), $allowed_html),
                'dependency' => array('back_top_enable', '==', 'true')
            ),
        )
    ));

    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('sitebar', 'foresty'),
        'id' => 'theme_general_sitebar_options',
        'icon' => 'fa fa-arrow-up',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Sitebar Option', 'foresty') . '</h3>'
            ),
            array(
                'id' => 'sitebar_logo',
                'type' => 'media',
                'title' => esc_html__('Sitebar Logo', 'foresty'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'sitebar_content_1',
                'type' => 'text',
                'title' => esc_html__('Sitebar content', 'foresty'),
                'default' => esc_html__('We understand better that enim ad minim veniam, consectetur adipis cing elit, sed do', 'foresty'),
            ),
            array(
                'id' => 'sitebar_content_2',
                'type' => 'text',
                'title' => esc_html__('Sitebar content', 'foresty'),
                'default' => esc_html__('We understand better that enim ad minim veniam, consectetur adipi scing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'foresty'),
            ),
            array(
                'id' => 'sitebar_address',
                'type' => 'text',
                'title' => esc_html__('Sitebar Address', 'foresty'),
                'default' => esc_html__('Lavaca Street, Suite 2000', 'foresty'),
            ),
            array(
                'id' => 'sitebar_email',
                'type' => 'text',
                'title' => esc_html__('Sitebar email', 'foresty'),
                'default' => esc_html__('email@evha.com', 'foresty'),
            ),
            array(
                'id' => 'sitebar_phone',
                'type' => 'text',
                'title' => esc_html__('Sitebar phone', 'foresty'),
                'default' => esc_html__('(+880) 172570051', 'foresty'),
            ),
            array(
                'id' => 'sitebar_facebook',
                'type' => 'text',
                'title' => esc_html__('Sitebar facebook url', 'foresty'),
                'default' => esc_html__('#', 'foresty'),
            ),
            array(
                'id' => 'sitebar_twitter',
                'type' => 'text',
                'title' => esc_html__('Sitebar twitter url', 'foresty'),
                'default' => esc_html__('#', 'foresty'),
            ),
            array(
                'id' => 'sitebar_instagram',
                'type' => 'text',
                'title' => esc_html__('Sitebar instagram', 'foresty'),
                'default' => esc_html__('#', 'foresty'),
            ),
            array(
                'id' => 'sitebar_linkedin',
                'type' => 'text',
                'title' => esc_html__('Sitebar linkedin', 'foresty'),
                'default' => esc_html__('#', 'foresty'),
            ),
        )
    ));

    /*----------------------------------
        Header & Footer Style
    -----------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Set Header & Footer Type', 'foresty'),
        'id' => 'header_footer_style_options',
        'icon' => 'eicon-banner',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => esc_html__('Global Header Style', 'foresty'),
            ),
            array(
                'id' => 'navbar_type',
                'title' => esc_html__('Navbar Type', 'foresty'),
                'type' => 'image_select',
                'options' => array(
                    '' => FORESTY_THEME_SETTINGS_IMAGES . '/header/01.png',
                    'style-01' => FORESTY_THEME_SETTINGS_IMAGES . '/header/02.png'
                ),
                'default' => '',
                'desc' => wp_kses(__('you can set <mark>navbar type</mark> it will show in every page except you select specific navbar type form page settings.', 'foresty'), $allowed_html),
            ),
            array(
                'type' => 'subheading',
                'content' => esc_html__('Global Footer Style', 'foresty'),
            ),
            array(
                'id' => 'footer_type',
                'title' => esc_html__('Footer Type', 'foresty'),
                'type' => 'image_select',
                'options' => array(
                    '' => FORESTY_THEME_SETTINGS_IMAGES . '/footer/01.png',
                    'style-01' => FORESTY_THEME_SETTINGS_IMAGES . '/footer/02.png'
                ),
                'default' => '',
                'desc' => wp_kses(__('you can set <mark>footer type</mark> it will show in every page except you select specific navbar type form page settings.', 'foresty'), $allowed_html),
            ),
        )
    ));

    /*-------------------------------------------------------
       ** Entire Site Header  Options
   --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'headers_settings',
        'title' => esc_html__('Headers', 'foresty'),
        'icon' => 'fa fa-home'
    ));
    /* Header Style 01 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header One', 'foresty'),
        'id' => 'theme_header_one_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Logo Options', 'foresty') . '</h3>'
            ),
            array(
                'id' => 'header_one_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'foresty'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'header_one_logo_two',
                'type' => 'media',
                'title' => esc_html__('Logo Two', 'foresty'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'header_right_btn_text',
                'type' => 'text',
                'title' => esc_html__('Right Btn text', 'foresty'),
                'default' => 'Get A Quote',
            ),
            array(
                'id' => 'header_right_btn_url',
                'type' => 'text',
                'title' => esc_html__('Right Btn url', 'foresty'),
                'default' => esc_html__('#', 'foresty'),
            ),
            array(
                'id' => 'header_navbar_button',
                'type' => 'switcher',
                'title' => esc_html__('Info Button', 'foresty'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> navbar button of header two', 'foresty'), $allowed_html),
            ),
        )
    ));

    /* Header Style 02 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header Two', 'foresty'),
        'id' => 'theme_header_two_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Navbar Options', 'foresty') . '</h3>'
            ),
            array(
                'id' => 'header_two_logo',
                'type' => 'media',
                'title' => esc_html__('header two logo', 'foresty'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> bg</mark> here it will overwrite customizer uploaded bg', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'header_two_mail',
                'type' => 'text',
                'title' => esc_html__('mail', 'foresty'),
                'default' => esc_html__('Info.Company@Gmail.Com', 'foresty')
            ),
            array(
                'id' => 'header_two_location',
                'type' => 'text',
                'title' => esc_html__('location', 'foresty'),
                'default' => esc_html__('85 Ketch Harbour RoadBensalem, PA 19020', 'foresty')
            ),
            array(
                'id' => 'header_two_facebook',
                'type' => 'text',
                'title' => esc_html__('Header facebook url', 'foresty'),
                'default' => esc_html__('#', 'foresty'),
            ),
            array(
                'id' => 'header_two_twitter',
                'type' => 'text',
                'title' => esc_html__('Header twitter url', 'foresty'),
                'default' => esc_html__('#', 'foresty'),
            ),
            array(
                'id' => 'header_two_instagram',
                'type' => 'text',
                'title' => esc_html__('Header instagram', 'foresty'),
                'default' => esc_html__('#', 'foresty'),
            ),
            array(
                'id' => 'header_two_linkedin',
                'type' => 'text',
                'title' => esc_html__('Header linkedin', 'foresty'),
                'default' => esc_html__('#', 'foresty'),
            ),
        )
    ));

    /* Breadcrumb */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Breadcrumb', 'foresty'),
        'id' => 'breadcrumb_options',
        'icon' => ' eicon-product-breadcrumbs',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Breadcrumb Options', 'foresty') . '</h3>'
            ),
            array(
                'id' => 'breadcrumb_enable',
                'title' => esc_html__('Breadcrumb', 'foresty'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide breadcrumb', 'foresty'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'breadcrumb_bg',
                'title' => esc_html__('Background Image', 'foresty'),
                'type' => 'background',
                'desc' => wp_kses(__('you can set <mark>background</mark> for breadcrumb', 'foresty'), $allowed_html),
                'default' => array(
                    'background-size' => 'cover',
                    'background-position' => 'center bottom',
                    'background-repeat' => 'no-repeat',
                ),
                'background_color' => false,
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
            array(
                'id' => 'breadcrumb_bg_color',
                'title' => esc_html__('Breadcrumb Background Color', 'foresty'),
                'type' => 'color',
                'default' => 'rgba(232,0,0, 0.6);',
                'desc' => wp_kses(__('you can set <mark>overlay color</mark> for Breadcrumb background image', 'foresty'), $allowed_html),
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
        )
    ));


    /*-------------------------------------------------------
           ** Footer  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Footer', 'foresty'),
        'id' => 'footer_options',
        'icon' => ' eicon-footer',
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_general_options',
        'title' => esc_html__('Footer One', 'foresty'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Settings One', 'foresty') . '</h3>'
            ),
            array(
                'id' => 'footer_one_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'foresty'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'footer_one_info_item',
                'type' => 'switcher',
                'title' => esc_html__('Info Item Button', 'foresty'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item of header five', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'footer_one_info_item_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Info Item Repeater', 'foresty'),
                'dependency' => array('footer_one_info_item', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'footer_one_info_item_title',
                        'type' => 'text',
                        'title' => esc_html__('Info  Title', 'foresty'),
                        'default' => esc_html__('Call Us Free', 'foresty')
                    ),
                    array(
                        'id' => 'footer_one_info_item_number',
                        'type' => 'text',
                        'title' => esc_html__('Info Number', 'foresty'),
                        'default' => esc_html__('+91 458 654 528', 'foresty')
                    ),
                )
            ),
            array(
                'id' => 'footer_one_social_item',
                'type' => 'switcher',
                'title' => esc_html__('Info Item Button', 'foresty'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item of header five', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'footer_one_social_item_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Info Item Repeater', 'foresty'),
                'dependency' => array('footer_one_social_item', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'footer_one_social_item_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Info  Title', 'foresty'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id' => 'footer_one_social_item_url',
                        'type' => 'text',
                        'title' => esc_html__('Info Number', 'foresty'),
                        'default' => esc_html__('#', 'foresty')
                    ),
                )
            ),
            array(
                'id' => 'footer_spacing',
                'title' => esc_html__('Footer Spacing', 'foresty'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set footer spacing', 'foresty'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'footer_top_spacing',
                'title' => esc_html__('Footer Top Spacing', 'foresty'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer top', 'foresty'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 100,
                'dependency' => array('footer_spacing', '==', 'true')
            ),
            array(
                'id' => 'footer_bottom_spacing',
                'title' => esc_html__('Footer Bottom Spacing', 'foresty'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer bottom', 'foresty'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 65,
                'dependency' => array('footer_spacing', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Copyright Area Options', 'foresty') . '</h3>'
            ),
            array(
                'id' => 'footer_shortcode',
                'type' => 'textarea',
                'title' => esc_html__('Footer Shortcode', 'foresty'),
                'shortcoder' => 'foresty_shortcodes'
            ),
            array(
                'id' => 'copyright_area_spacing',
                'title' => esc_html__('Copyright Area Spacing', 'foresty'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set copyright area spacing', 'foresty'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'copyright_text',
                'title' => esc_html__('Copyright Area Text', 'foresty'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'foresty'), $allowed_html)
            ),
            array(
                'id' => 'copyright_area_top_spacing',
                'title' => esc_html__('Copyright Area Top Spacing', 'foresty'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area top', 'foresty'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_area_spacing', '==', 'true')
            ),
            array(
                'id' => 'copyright_area_bottom_spacing',
                'title' => esc_html__('Copyright Area Bottom Spacing', 'foresty'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area bottom', 'foresty'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_area_spacing', '==', 'true')
            )
        )
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_two_options',
        'title' => esc_html__('Footer Two', 'foresty'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Top Settings', 'foresty') . '</h3>'
            ),
            array(
                'id' => 'footer_two_bg',
                'type' => 'media',
                'title' => esc_html__('footer two bg img', 'foresty'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded img', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'footer_two_widget_bg',
                'type' => 'media',
                'title' => esc_html__('footer two widget bg img', 'foresty'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded img', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'footer_two_logo',
                'type' => 'media',
                'title' => esc_html__('footer two logo', 'foresty'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded img', 'foresty'), $allowed_html),
            ),
            array(
                'id' => 'footer_two_shortcode',
                'type' => 'text',
                'title' => esc_html__('footer two shortcode', 'foresty')
            ),
            array(
                'id' => 'footer_two_social_item_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Item Repeater', 'foresty'),
                'fields' => array(
                    array(
                        'id' => 'footer_two_social_item_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Social  Title', 'foresty'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id' => 'footer_two_social_item_url',
                        'type' => 'text',
                        'title' => esc_html__('Social Number', 'foresty'),
                        'default' => esc_html__('#', 'foresty')
                    ),
                )
            ),
        )
    ));

    /*-------------------------------------------------------
          ** Blog  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_settings',
        'title' => esc_html__('Blog Settings', 'foresty'),
        'icon' => 'fa fa-book'
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'blog_settings',
        'id' => 'blog_post_options',
        'title' => esc_html__('Blog Post', 'foresty'),
        'icon' => 'fa fa-list-ul',
        'fields' => Foresty_Group_Fields::post_meta('blog_post', esc_html__('Blog Page', 'foresty'))
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'blog_settings',
        'id' => 'blog_single_post_options',
        'title' => esc_html__('Single Post', 'foresty'),
        'icon' => 'fa fa-list-alt',
        'fields' => Foresty_Group_Fields::post_meta('blog_single_post', esc_html__('Blog Single Page', 'foresty'))
    ));

    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'shop_settings',
        'title' => esc_html__('Shop Settings', 'foresty'),
        'icon' => 'fas fa-shopping-basket',
    ));
    /*  Product page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'product_shop_page',
        'title' => esc_html__('Product Page', 'foresty'),
        'parent' => 'shop_settings',
        'icon' => 'fas fa-shopping-basket',
        'fields' => Foresty_Group_Fields::page_layout_options(esc_html__('Product Shop Page', 'foresty'), 'product_shop')
    ));
    /*  Product single page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'product_shop_single_page',
        'title' => esc_html__('Product Single Page', 'foresty'),
        'parent' => 'shop_settings',
        'icon' => 'fas fa-shopping-basket',
        'fields' => array(
            array(
                'id' => 'product_shop_single_page_bg_color',
                'type' => 'color',
                'title' => esc_html__('Page Background Color', 'foresty')
            ),
            array(
                'id' => 'product_shop_single_page_spacing_top',
                'title' => esc_html__('Page Spacing Top', 'foresty'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page content area.', 'foresty'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
            array(
                'id' => 'product_shop_single_page_spacing_bottom',
                'title' => esc_html__('Page Spacing Bottom', 'foresty'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page content area.', 'foresty'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 100,
            ),
        ),
    ));

    /*-------------------------------------------------------
          ** Pages & templates Options
   --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'pages_and_template',
        'title' => esc_html__('Pages Settings', 'foresty'),
        'icon' => 'fa fa-files-o'
    ));
    /*  404 page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => '404_page',
        'title' => esc_html__('404 Page', 'foresty'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-exclamation-triangle',
        'fields' => array(
            array(
                'id' => 'error_bg_switch',
                'title' => esc_html__('404 Image Enable', 'foresty'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide breadcrumb', 'foresty'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'error_bg',
                'title' => esc_html__('404 Image', 'foresty'),
                'type' => 'media',
                'desc' => wp_kses(__('you can set <mark>background</mark> for breadcrumb', 'foresty'), $allowed_html),
                'dependency' => array('error_bg_switch', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('404 Page Options', 'foresty') . '</h3>',
            ),
            array(
                'id' => '404_bg_color',
                'type' => 'color',
                'title' => esc_html__('Page Background Color', 'foresty'),
            ),
            array(
                'id' => '404_title',
                'title' => esc_html__('Title', 'foresty'),
                'type' => 'text',
                'info' => wp_kses(__('you can change <mark>title</mark> of 404 page', 'foresty'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('Sorry! The Page Not Found', 'foresty'))
            ),
            array(
                'id' => '404_paragraph',
                'title' => esc_html__('Paragraph', 'foresty'),
                'type' => 'textarea',
                'info' => wp_kses(__('you can change <mark>paragraph</mark> of 404 page', 'foresty'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('Oops! The page you are looking for does not exit. it might been moved or deleted.', 'foresty'))
            ),
            array(
                'id' => '404_button_text',
                'title' => esc_html__('Button Text', 'foresty'),
                'type' => 'text',
                'info' => wp_kses(__('you can change <mark>button text</mark> of 404 page', 'foresty'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('back to home', 'foresty'))
            ),
            array(
                'id' => '404_spacing_top',
                'title' => esc_html__('Page Spacing Top', 'foresty'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page content area.', 'foresty'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
            array(
                'id' => '404_spacing_bottom',
                'title' => esc_html__('Page Spacing Bottom', 'foresty'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page content area.', 'foresty'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
        )
    ));

    /*  blog page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_page',
        'title' => esc_html__('Blog Page', 'foresty'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => Foresty_Group_Fields::page_layout_options(esc_html__('Blog', 'foresty'), 'blog')
    ));
    /*  blog single page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_single_page',
        'title' => esc_html__('Blog Single Page', 'foresty'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => Foresty_Group_Fields::page_layout_options(esc_html__('Blog Single', 'foresty'), 'blog_single')
    ));
    /*  archive page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'archive_page',
        'title' => esc_html__('Archive Page', 'foresty'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-archive',
        'fields' => Foresty_Group_Fields::page_layout_options(esc_html__('Archive', 'foresty'), 'archive')
    ));
    /*  search page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'search_page',
        'title' => esc_html__('Search Page', 'foresty'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-search',
        'fields' => Foresty_Group_Fields::page_layout_options(esc_html__('Search', 'foresty'), 'search')
    ));

    /*-------------------------------------------------------
           ** Backup  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'backup',
        'title' => esc_html__('Import / Export', 'foresty'),
        'icon' => 'eicon-export-kit',
        'fields' => array(
            array(
                'type' => 'notice',
                'style' => 'warning',
                'content' => esc_html__('You can save your current options. Download a Backup and Import.', 'foresty'),
            ),
            array(
                'type' => 'backup',
                'title' => esc_html__('Backup & Import', 'foresty')
            )
        )
    ));
}
