<?php
/**
 * Theme Metabox Options
 * @package foresty
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {

    $allowed_html = foresty()->kses_allowed_html(array('mark'));

    $prefix = 'foresty';

    /*-------------------------------------
        Post Format Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_post_video_options', array(
        'title' => esc_html__('Video Post Format Options', 'foresty'),
        'post_type' => 'post',
        'post_formats' => 'video'
    ));
    CSF::createSection($prefix . '_post_video_options', array(
        'fields' => array(
            array(
                'id' => 'video_url',
                'type' => 'text',
                'title' => esc_html__('Enter Video URL', 'foresty'),
                'desc' => wp_kses(__('enter <mark>video url</mark> to show in frontend', 'foresty'), $allowed_html)
            )
        )
    ));
    CSF::createMetabox($prefix . '_post_gallery_options', array(
        'title' => esc_html__('Gallery Post Format Options', 'foresty'),
        'post_type' => 'post',
        'post_formats' => 'gallery'
    ));
    CSF::createSection($prefix . '_post_gallery_options', array(
        'fields' => array(
            array(
                'id' => 'gallery_images',
                'type' => 'gallery',
                'title' => esc_html__('Select Gallery Photos', 'foresty'),
                'desc' => wp_kses(__('select <mark>gallery photos</mark> to show in frontend', 'foresty'), $allowed_html)
            )
        )
    ));

    /*-------------------------------------
      Page Container Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_page_container_options', array(
        'title' => esc_html__('Page Options', 'foresty'),
        'post_type' => array('page'),
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Layout & Colors', 'foresty'),
        'icon' => 'fa fa-columns',
        'fields' => Foresty_Group_Fields::page_layout()
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Header Footer & Breadcrumb', 'foresty'),
        'icon' => 'fa fa-header',
        'fields' => Foresty_Group_Fields::Page_Container_Options('header_options')
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Width & Padding', 'foresty'),
        'icon' => 'fa fa-file-o',
        'fields' => Foresty_Group_Fields::Page_Container_Options('container_options')
    ));
    //  Service Meta Box
    CSF::createMetabox($prefix . '_service_options', array(
        'title' => esc_html__('Service Options', 'foresty'),
        'post_type' => 'service',
    ));
    CSF::createSection($prefix . '_service_options', array(
        'fields' => array(
            array(
                'id' => 'service_icon',
                'type' => 'media',
                'title' => esc_html__('Icon', 'foresty'),
                'desc' => wp_kses(__('Select Your Icon', 'foresty'), $allowed_html)
            ),
            array(
                'id' => 'service_content',
                'type' => 'textarea',
                'title' => esc_html__('service content', 'foresty'),
                'desc' => wp_kses(__('Select Your service content', 'foresty'), $allowed_html)
            )
        )
    ));

    /*-------------------------------------
     Team Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_team_options', array(
        'title' => esc_html__('Team Options', 'foresty'),
        'post_type' => array('team'),
        'priority' => 'high'
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Team Info', 'foresty'),
        'id' => 'foresty-info',
        'fields' => array(
            array(
                'id' => 'designation',
                'type' => 'text',
                'title' => esc_html__('Designation', 'foresty'),
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'foresty'),
            ),
            array(
                'id' => 'team-info',
                'type' => 'repeater',
                'title' => esc_html__('Team Info', 'foresty'),
                'fields' => array(

                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'foresty')
                    ),
                    array(
                        'id' => 'count',
                        'type' => 'text',
                        'title' => esc_html__('count value', 'foresty')
                    ),
                ),
            ),
        )
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Social Info', 'foresty'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'social-icons',
                'type' => 'repeater',
                'title' => esc_html__('Social Info', 'foresty'),
                'fields' => array(

                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'foresty')
                    ),
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'foresty')
                    ),
                    array(
                        'id' => 'url',
                        'type' => 'text',
                        'title' => esc_html__('URL', 'foresty')
                    ),

                ),
            ),
        )
    ));

    //  Project Meta Box
    CSF::createMetabox($prefix . '_project_options', array(
        'title' => esc_html__('Project Options', 'foresty'),
        'post_type' => 'project',
    ));

    CSF::createSection($prefix . '_project_options', array(
        'fields' => array(
            array(
                'id' => 'project_meta',
                'type' => 'text',
                'title' => esc_html__('Project Meta', 'foresty'),
                'default' => esc_html__('Las vegas ', 'foresty'),
            ),
            array(
                'id' => 'project_clients',
                'type' => 'text',
                'title' => esc_html__('Project Clients', 'foresty'),
                'default' => esc_html__('Porter Victoria ', 'foresty'),
            ),
            array(
                'id' => 'project_cat',
                'type' => 'text',
                'title' => esc_html__('Category', 'foresty'),
                'default' => esc_html__('It Service ', 'foresty'),
            ),
            array(
                'id' => 'project_date',
                'type' => 'text',
                'title' => esc_html__('Project Date', 'foresty'),
                'default' => esc_html__('20 January, 2023 ', 'foresty'),
            ),
            array(
                'id' => 'project_location',
                'type' => 'text',
                'title' => esc_html__('Project Location', 'foresty'),
                'default' => esc_html__('Cakung, Jakarta ', 'foresty'),
            )
        )
    ));
    
}//endif