<?php
/**
 * Theme functions & definitations
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package foresty
 */

/**
 * Define Theme Folder Path & URL Constant
 * @package foresty
 * @since 1.0.0
 */

define('FORESTY_THEME_ROOT', get_template_directory());
define('FORESTY_THEME_ROOT_URL', get_template_directory_uri());
define('FORESTY_INC', FORESTY_THEME_ROOT . '/inc');
define('FORESTY_THEME_SETTINGS', FORESTY_INC . '/theme-settings');
define('FORESTY_THEME_SETTINGS_IMAGES', FORESTY_THEME_ROOT_URL . '/inc/theme-settings/images');
define('FORESTY_TGMA', FORESTY_INC . '/plugins/tgma');
define('FORESTY_DYNAMIC_STYLESHEETS', FORESTY_INC . '/theme-stylesheets');
define('FORESTY_CSS', FORESTY_THEME_ROOT_URL . '/assets/css');
define('FORESTY_JS', FORESTY_THEME_ROOT_URL . '/assets/js');
define('FORESTY_ASSETS', FORESTY_THEME_ROOT_URL . '/assets');
define('FORESTY_DEV', true);


/**
 * Theme Initial File
 * @package foresty
 * @since 1.0.0
 */
if (file_exists(FORESTY_INC . '/theme-init.php')) {
    require_once FORESTY_INC . '/theme-init.php';
}


/**
 * Codester Framework Functions
 * @package foresty
 * @since 1.0.0
 */
if (file_exists(FORESTY_INC . '/theme-cs-function.php')) {
    require_once FORESTY_INC . '/theme-cs-function.php';
}


/**
 * Theme Helpers Functions
 * @package foresty
 * @since 1.0.0
 */
if (file_exists(FORESTY_INC . '/theme-helper-functions.php')) {

    require_once FORESTY_INC . '/theme-helper-functions.php';
    if (!function_exists('foresty')) {
        function foresty()
        {
            return class_exists('Foresty_Helper_Functions') ? new Foresty_Helper_Functions() : false;
        }
    }
}
/**
 * Nav menu fallback function
 * @since 1.0.0
 */
if (is_user_logged_in()) {
    function foresty_theme_fallback_menu()
    {
        get_template_part('template-parts/default', 'menu');
    }
}

