<?php
/**
 * Theme About Me Widget
 * @package Foresty
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('foresty_about_me_widget', array(
        'title' => esc_html__('Foresty: About Me', 'foresty-core'),
        'classname' => 'foresty-widget-about-me',
        'description' => esc_html__('Display about Me widget', 'foresty-core'),
        'fields' => array(
            array(
                'id' => 'about_me_title',
                'type' => 'textarea',
                'title' => esc_html__('Title', 'Foresty-core'),
                'default' => esc_html__('about us', 'foresty-core')
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'Foresty-core'),
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.', 'foresty-core')
            ),
            array(
                'id' => 'location',
                'type' => 'textarea',
                'title' => esc_html__('location url', 'Foresty-core'),
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.', 'foresty-core')
            ),

            array(
                'id' => 'foresty-footer-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social', 'foresty-core'),
                'fields' => array(

                    array(
                        'id' => 'foresty-footer-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Social Name', 'foresty-core'),
                        'default' => 'facebook'
                    ),
                    array(
                        'id' => 'foresty-footer-social-url',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Url', 'foresty-core'),
                        'default' => esc_html__('#', 'foresty-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('foresty_about_me_widget')) {
        function foresty_about_me_widget($args, $instance)
        {

            echo $args['before_widget'];

            // var_dump( $args ); // Widget arguments
            // var_dump( $instance ); // Saved values from database

            $about_me_title = $instance['about_me_title'] ?? '';
            $paragraph = $instance['description'] ?? '';
            $location = $instance['location'] ?? '';
            $socialIcon = is_array($instance['foresty-footer-social-icon-repeater']) && !empty($instance['foresty-footer-social-icon-repeater']) ? $instance['foresty-footer-social-icon-repeater'] : [];


            ?>
            <div class="footer-widget widget">
                <div class="about_me_widget style-01 footer__item">
                    <div class="footer__item-title">
                        <h4 class="widget-headline"><?php echo $about_me_title; ?></h4>
                    </div>
                    <p> <?php echo $paragraph; ?></p>
                    <ul class="contact_info_list">
                        <?php
                        foreach ($socialIcon as $icon) {
                            echo '<li class="single-info-item-list">
                            <div class="icon">
                                <a href="'.$icon['foresty-footer-social-url'].'">
                                    <i class="' . $icon['foresty-footer-social-icon'] . '"></i>
                                </a>
                            </div>
                        </li>';
                        };
                        ?>
                    </ul>
                    <?php if (!empty($location)) { ?>
                        <a class="d-block mt-4" href="<?php echo $location; ?>" class="footer__item-map-popup map-popup">View Map <i class="fa-solid fa-location-arrow"></i></a>
                    <?php } ?>
                </div>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>