<?php
/**
 * Theme Core Init
 * @package foresty
 * @since 1.0.0
 */

if (!defined("ABSPATH")) {
	exit(); //exit if access directly
}

if (!class_exists('Foresty_Core_Init')) {

	class Foresty_Core_Init
	{
	   /**
        * $instance
        * @since 1.0.0
        */
		protected static $instance;

		public function __construct()
		{
			//Load plugin assets
			add_action('wp_enqueue_scripts', array($this, 'plugin_assets'));
			//Load plugin admin assets
			add_action('admin_enqueue_scripts', array($this, 'admin_assets'));
			//load plugin text domain
			add_action('init', array($this, 'load_textdomain'));
			//add custom icon to codester framework
			add_filter('csf_field_icon_add_icons', array($this, 'csf_custom_icon'));
			//load plugin dependency files()
            add_action('plugin_loaded', array($this, 'load_plugin_dependency_files'));
		}

	   /**
        * getInstance()
        * @since 1.0.0
        */
		public static function getInstance()
		{
			if (null == self::$instance) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Load Plugin Text domain
		 * @since 1.0.0
		 */
		public function load_textdomain()
		{
			load_plugin_textdomain('foresty-core', false, FORESTY_CORE_ROOT_PATH . '/languages');
		}

		/**
		 * Load plugin dependency files()
		 * @since 1.0.0
		 */
		public function load_plugin_dependency_files()
		{
			$includes_files = array(
				array(
					'file-name' => 'codestar-framework',
					'folder-name' => FORESTY_CORE_LIB . '/codestar-framework'
				),
				array(
					'file-name' => 'theme-menu-page',
					'folder-name' => FORESTY_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-custom-post-type',
					'folder-name' => FORESTY_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-post-column-customize',
					'folder-name' => FORESTY_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-foresty-core-excerpt',
					'folder-name' => FORESTY_CORE_INC
				),
				array(
					'file-name' => 'csf-taxonomy',
					'folder-name' => FORESTY_CORE_INC
				),
				array(
					'file-name' => 'theme-core-shortcodes',
					'folder-name' => FORESTY_CORE_INC
				),
				array(
					'file-name' => 'elementor-widget-init',
					'folder-name' => FORESTY_CORE_ELEMENTOR
				),
                array(
                    'file-name' => 'theme-social-share-widget',
                    'folder-name' => FORESTY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-about-me-widget',
                    'folder-name' => FORESTY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-about-us-widget',
                    'folder-name' => FORESTY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-search-widget',
                    'folder-name' => FORESTY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-tags-menu',
                    'folder-name' => FORESTY_CORE_WP_WIDGETS
                ),
				array(
					'file-name' => 'theme-recent-post-widget',
					'folder-name' => FORESTY_CORE_WP_WIDGETS
				),
				array(
					'file-name' => 'theme-contact-info-widget',
					'folder-name' => FORESTY_CORE_WP_WIDGETS
				),
                array(
                    'file-name' => 'theme-service-category-widget',
                    'folder-name' => FORESTY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-request-form-widget',
                    'folder-name' => FORESTY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-category-widget',
                    'folder-name' => FORESTY_CORE_WP_WIDGETS
                ),
				array(
					'file-name' => 'theme-demo-data-import',
					'folder-name' => FORESTY_CORE_DEMO_IMPORT
				),
			);

            if (defined('ELEMENTOR_VERSION')) {
                $includes_files[] = array(
                    'file-name' => 'theme-elementor-icon-manager',
                    'folder-name' => FORESTY_CORE_INC
                );
            }
			if (is_array($includes_files) && !empty($includes_files)) {
				foreach ($includes_files as $file) {
					if (file_exists($file['folder-name'] . '/' . $file['file-name'] . '.php')) {
						require_once $file['folder-name'] . '/' . $file['file-name'] . '.php';
					}
				}
			}
		}

		/**
		 * Admin assets
		 * @since 1.0.0
		 */
		public function plugin_assets()
		{
			self::load_plugin_css_files();
			self::load_plugin_js_files();
		}

		/**
		 * Load plugin css files()
		 * @since 1.0.0
		 */
		public function load_plugin_css_files()
		{
			$plugin_version = FORESTY_CORE_VERSION;
			$all_css_files = array(
				array(
					'handle' => 'flaticon',
					'src' => FORESTY_CORE_CSS . '/flaticon.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
                array(
                    'handle' => 'nice-select',
                    'src' => FORESTY_CORE_CSS . '/nice-select.css',
                    'deps' => array(),
                    'ver' => $plugin_version,
                    'media' => 'all'
                ),
                array(
                    'handle' => 'slick',
                    'src' => FORESTY_CORE_CSS . '/slick.css',
                    'deps' => array(),
                    'ver' => $plugin_version,
                    'media' => 'all'
                ),
				array(
					'handle' => 'fontawesome',
					'src' => FORESTY_CORE_CSS . '/font-awesome.min.css',
					'deps' => array(),
					'ver' => '5.12.0',
					'media' => 'all'
				),
				array(
					'handle' => 'foresty-core-main-style',
					'src' => FORESTY_CORE_CSS . '/main-style.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				)
			);
			
			if (!foresty_core()->is_foresty_active()) {
				$all_css_files[] = array(
					'handle' => 'animate',
					'src' => FORESTY_CORE_CSS . '/animate.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'bootstrap',
					'src' => FORESTY_CORE_CSS . '/bootstrap.min.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'magnific-popup',
					'src' => FORESTY_CORE_CSS . '/magnific-popup.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'foresty-main-style',
					'src' => FORESTY_CORE_CSS . '/theme-style.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'foresty-responsive',
					'src' => FORESTY_CORE_CSS . '/theme-responsive.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
			}
			$all_css_files = apply_filters('foresty_core_css', $all_css_files);

			if (is_array($all_css_files) && !empty($all_css_files)) {
				foreach ($all_css_files as $css) {
					call_user_func_array('wp_enqueue_style', $css);
				}
			}
		}

		/**
		 * Load plugin js
		 * @since 1.0.0
		 */
		public function load_plugin_js_files()
		{
			$plugin_version = FORESTY_CORE_VERSION;
			// all js files
            wp_enqueue_script( 'wow', FORESTY_CORE_JS . '/wow.min.js', array('jquery'), $plugin_version, true );
            wp_enqueue_script( 'nice-select', FORESTY_CORE_JS . '/nice-select.min.js', array('jquery'), $plugin_version, true );
            wp_enqueue_script( 'counterup', FORESTY_CORE_JS . '/counterup.min.js', array('jquery'), $plugin_version, true );
            wp_enqueue_script( 'waypoints', FORESTY_CORE_JS . '/waypoints.min.js', array('jquery'), $plugin_version, true );
            wp_enqueue_script( 'swiper', FORESTY_CORE_JS . '/swiper.min.js', array('jquery'), $plugin_version, true );
            wp_enqueue_script( 'isotope', FORESTY_CORE_JS . '/isotope.min.js', array('jquery'), $plugin_version, true );
            wp_enqueue_script( 'foresty-core-main-script', FORESTY_CORE_JS . '/main.js', array('jquery'), time(), true );

		}

		/**
		 * Admin assets
		 * @since 1.0.0
		 */
		public function admin_assets()
		{
			self::load_admin_css_files();
			self::load_admin_js_files();
		}

		/**
		 * Load plugin admin css files()
		 * @since 1.0.0
		 */
		public function load_admin_css_files()
		{
			$plugin_version = FORESTY_CORE_VERSION;
			$all_css_files = array(
				array(
					'handle' => 'foresty-core-admin-style',
					'src' => FORESTY_CORE_ADMIN_ASSETS . '/css/admin.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
				array(
					'handle' => 'flaticon',
					'src' => FORESTY_CORE_CSS . '/flaticon.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
			);

			$all_css_files = apply_filters('foresty_admin_css', $all_css_files);
			if (is_array($all_css_files) && !empty($all_css_files)) {
				foreach ($all_css_files as $css) {
					call_user_func_array('wp_enqueue_style', $css);
				}
			}
		}

		/**
		 * Load plugin admin js
		 * @since 1.0.0
		 */
		public function load_admin_js_files()
		{
			$plugin_version = FORESTY_CORE_VERSION;
			wp_enqueue_script( 'foresty-core-widget', FORESTY_CORE_ADMIN_ASSETS . '/js/widget.js', array('jquery'), $plugin_version, true );
		}

		/**
		 * Add Custom Icon To Codester Framework
		 * @since 1.0.0
		 */
		public function csf_custom_icon($icons)
		{
			//adding new icon
			$icons[]  = array(
				'title' => esc_html__('Flaticon', 'foresty-core'),
				'icons' => array(
					'flaticon-user',
					'flaticon-quotation-mark',
					'flaticon-calendar',
					'flaticon-repeat',
					'flaticon-flag',
					'flaticon-guide',
					'flaticon-user-1',
					'flaticon-photo-camera',
					'flaticon-presentation',
					'flaticon-volume',
					'flaticon-money',
					'flaticon-star',
					'flaticon-instagram',
					'flaticon-youtube',
					'flaticon-facebook',
					'flaticon-twitter',
					'flaticon-google-plus',
					'flaticon-phone',
					'flaticon-placeholder',
					'flaticon-add',
					'flaticon-close',
					'flaticon-email',
					'flaticon-send',
					'flaticon-pencil',
					'flaticon-clock',
					'flaticon-wifi',
					'flaticon-magnifying-glass',
					'flaticon-user-2',
					'flaticon-right-arrow',
					'flaticon-left-arrow',
					'flaticon-right-arrow-1',
					'flaticon-left-arrow-1',
					'flaticon-user-3',
					'flaticon-armchair',
					'flaticon-protection',
					'flaticon-globe',
					'flaticon-calendar-1',
					'flaticon-stewardess',
					'flaticon-plane',
					'flaticon-passport',
					'flaticon-money-1',
					'flaticon-success',
					'flaticon-like',
					'flaticon-hand-gesture',
					'flaticon-pilot',
					'flaticon-airplane',
					'flaticon-helicopter',
					'flaticon-air-ambulance',
					'flaticon-plane-1',
					'flaticon-shield',
					'flaticon-route',
					'flaticon-jet',
					'flaticon-travel',
					'flaticon-take-off',
					'flaticon-radar',
					'flaticon-plane-2',
					'flaticon-passenger',
					'flaticon-user-4',
					'flaticon-airplane-1',
					'flaticon-black-plane',
					'flaticon-light-bulb',
					'flaticon-lightbulb',
					'flaticon-light-bulb-1',
					'flaticon-video-call',
					'flaticon-video-player',
					'flaticon-play',
					'flaticon-youtube-1',
					'flaticon-video-camera',
					'flaticon-play-1',
					'flaticon-movie-player',
					'flaticon-video',
					'flaticon-blocks-with-angled-cuts',
					'flaticon-straight-quotes',
					'flaticon-calendar-2',
					'flaticon-star-1',
					'flaticon-book',
					'flaticon-favorite',
					'flaticon-star-2',
					'flaticon-right',
					'flaticon-right-arrow-2',
					'flaticon-right-arrow-3',
					'flaticon-left-arrow-2',
					'flaticon-left-arrow-3',
					'flaticon-left-arrow-4',
					'flaticon-left-arrow-5',
					'flaticon-location',
					'flaticon-pin',
					'flaticon-location-1',
					'flaticon-location-2',
					'flaticon-email-1',
					'flaticon-email-2',
					'flaticon-mail',
					'flaticon-mail-1',
					'flaticon-mail-2',
					'flaticon-split',
					'flaticon-road-sign',
					'flaticon-directions',
					'flaticon-direction',
					'flaticon-directions-1',
					'flaticon-speedometer',
					'flaticon-chat',
					'flaticon-camera',
					'flaticon-video-player-1',
					'flaticon-camera-1',
					'flaticon-experience'
				)
			);

			$icons = array_reverse($icons);

			return $icons;
		}
	} //end class
	if (class_exists('Foresty_Core_Init')) {
		Foresty_Core_Init::getInstance();
	}
}
