<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;

class Foresty_Testimonial_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-testimonial-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial Two', 'foresty-core');
    }

    public function get_keywords()
    {
        return ['Team', 'Member', 'Testimonial', "Gramentheme", 'Foresty'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-blockquote';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('subtitle',
        [
            'label' => esc_html__('subtitle', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter name', 'foresty-core'),
            'default' => esc_html__('OUR CLIENT’S FEEDBACK', 'foresty-core')
        ]);
        $this->add_control('title',
        [
            'label' => esc_html__('title', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter designation', 'foresty-core'),
            'default' => esc_html__('Foresty Loves People', 'foresty-core')
        ]);

        $this->add_control('content_devider', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $repeater = new Repeater();
        $repeater->add_control('main_img',
            [
                'label' => esc_html__('Main Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $repeater->add_control('name',
        [
            'label' => esc_html__('Name', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter name', 'foresty-core'),
            'default' => esc_html__('Kenneth S. Fisher', 'foresty-core')
        ]);
        $repeater->add_control('designation',
        [
            'label' => esc_html__('designation', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter designation', 'foresty-core'),
            'default' => esc_html__('Marketing Manager', 'foresty-core')
        ]);
        $repeater->add_control('content',
            [
                'label' => esc_html__('Description', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter content', 'foresty-core'),
                'default' => esc_html__('posuere luctus orci. Donec vitae mattis quam, vitae tempor arcu. Aenean non odio porttitor, convallis erat sit amet, facilisis velit. Nulla ornare convallis', 'foresty-core')
            ]
        );
        $repeater->add_control('ratting',
        [
            'label' => esc_html__('Ratting', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter name', 'foresty-core'),
            'default' => esc_html__('5', 'foresty-core')
        ]);
        $this->add_control('testimonial_items', [
            'label' => esc_html__('Testimonial Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title' => esc_html__('William Evans', 'foresty-core'),
                    'description' => esc_html__("posuere luctus orci. Donec vitae mattis quam, vitae tempor arcu. Aenean non odio porttitor, convallis erat sit amet, facilisis velit. Nulla ornare convallis", 'foresty-core'),
                ]
            ],

        ]);
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_testimonial_items = $settings['testimonial_items'];
        ?>

        <div class="testimonial-two pt-130 pb-130">
            <div class="container">
                <div class="testimonial-two__wrp bor">
                    <div class="testimonial__head-wrp bor-bottom pb-65 pt-65 pl-65 pr-65">
                        <div class="section-header theme-heading-title m-0">
                            <h5 class="subtitle mb-0 wow fadeInUp" data-wow-duration="1.2s" data-wow-delay=".2s">
                                <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_0_4338)">
                                    <path d="M17.3765 0.653721C17.1421 0.419863 16.8588 0.240914 16.5468 0.129768C16.2349 0.0186233 15.9023 -0.0219503 15.5728 0.0109712C13.478 0.213471 6.4333 1.08572 3.7123 3.80372C2.41163 5.10794 1.64035 6.84784 1.5474 8.68743C1.45446 10.527 2.04645 12.3358 3.20905 13.7645L11.504 5.46947C11.6455 5.33285 11.8349 5.25726 12.0316 5.25897C12.2282 5.26068 12.4163 5.33955 12.5554 5.47861C12.6945 5.61766 12.7733 5.80577 12.775 6.00242C12.7768 6.19907 12.7012 6.38852 12.5645 6.52997L4.27255 14.825C5.70072 15.9883 7.50935 16.581 9.34903 16.4886C11.1887 16.3962 12.9289 15.6253 14.2333 14.3247C16.9903 11.567 17.8333 4.54397 18.0275 2.45747C18.0593 2.12738 18.0174 1.79435 17.9048 1.48242C17.7922 1.17049 17.6118 0.887451 17.3765 0.653721ZM3.7123 14.3247C3.8913 14.5032 4.07705 14.671 4.26955 14.828L1.31455 17.783C1.17272 17.9192 0.983041 17.9944 0.786369 17.9921C0.589697 17.9899 0.401777 17.9105 0.263093 17.771C0.12441 17.6315 0.0460642 17.4431 0.0449343 17.2465C0.0438044 17.0498 0.119981 16.8605 0.257053 16.7195L3.21205 13.7645C3.36905 13.9565 3.5358 14.1432 3.7123 14.3247Z" fill="#4BAF47"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_0_4338">
                                    <rect width="18" height="18" fill="white" transform="translate(0.0371094)"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                                <?php echo $settings['subtitle']; ?>
                            </h5>
                            <h2 class="wow fadeInUp" data-wow-duration="1.4s" data-wow-delay=".4s"><?php echo $settings['title']; ?>
                            </h2>
                        </div>
                        <div class="dot-wrp wow fadeInUp mt-5 mt-sm-0" data-wow-duration="1.6s" data-wow-delay=".6s">
                            <div class="dot testimonial-two__dot"></div>
                        </div>
                    </div>
                    <div class="pt-45 pb-45 pr-55">
                        <div class="row g-4 align-items-center justify-content-between">
                            <div class="col-lg-7">
                                <div class="swiper testimonial-two__slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($all_testimonial_items as $item): ?>
                                            <div class="swiper-slide">
                                                <div class="testimonial-two__item pl-65">
                                                    <div class="testi-header mb-xl-5 mb-4">
                                                        <div class="testi-content">
                                                            <h3><?php echo $item['name']; ?></h3>
                                                            <span><?php echo $item['designation']; ?></span>
                                                        </div>
                                                        <i class="fa-solid fa-quote-right"></i>
                                                    </div>
                                                    <p><?php echo $item['content']; ?></p>
                                                    <div class="star mt-xl-5 mt-4">
                                                        <?php
                                                            $rating = $item['ratting'];
                                                        ?>
                                                        <?php for ($i=0; $i < $rating; $i++) { ?>
                                                            <i class="fa-solid fa-star"></i>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="testimonial-two__image">
                                    <div class="swiper testimonial-two__slider">
                                        <div class="swiper-wrapper">
                                            <?php foreach ($all_testimonial_items as $item): ?>
                                                <div class="swiper-slide">
                                                    <img src="<?php echo $item['main_img']['url']; ?>"
                                                        alt="image">
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Testimonial_Two_Widget());
