<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;

class Foresty_Testimonial_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-testimonial-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial: 01', 'foresty-core');
    }

    public function get_keywords()
    {
        return ['Team', 'Member', 'Testimonial', "Gramentheme", 'Foresty'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-blockquote';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('content_devider', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $repeater = new Repeater();
        $repeater->add_control('main_img',
            [
                'label' => esc_html__('Main Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $repeater->add_control('name',
        [
            'label' => esc_html__('Name', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter name', 'foresty-core'),
            'default' => esc_html__('Kenneth S. Fisher', 'foresty-core')
        ]);
        $repeater->add_control('designation',
        [
            'label' => esc_html__('designation', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter designation', 'foresty-core'),
            'default' => esc_html__('Marketing Manager', 'foresty-core')
        ]);
        $repeater->add_control('content',
            [
                'label' => esc_html__('Description', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter content', 'foresty-core'),
                'default' => esc_html__('posuere luctus orci. Donec vitae mattis quam, vitae tempor arcu. Aenean non odio porttitor, convallis erat sit amet, facilisis velit. Nulla ornare convallis', 'foresty-core')
            ]
        );
        $this->add_control('testimonial_items', [
            'label' => esc_html__('Testimonial Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title' => esc_html__('William Evans', 'foresty-core'),
                    'description' => esc_html__("posuere luctus orci. Donec vitae mattis quam, vitae tempor arcu. Aenean non odio porttitor, convallis erat sit amet, facilisis velit. Nulla ornare convallis", 'foresty-core'),
                ]
            ],

        ]);
        $this->end_controls_section();
		
		$this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Nabnar style Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('designation_color', [
            'label' => esc_html__('Designation Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial__item-head-info-con span" => "color: {{VALUE}}"
            ]
        ]);
		$this->add_control('quote_icon_color', [
            'label' => esc_html__('quote icon Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .testimonial__item-head i" => "color: {{VALUE}}",
			],
        ]);
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_testimonial_items = $settings['testimonial_items'];
        ?>

        <div class="testimonial__head-wrp mb-65 position-right-top">
            <div class="dot-wrp wow fadeInUp mt-5 mt-sm-0" data-wow-duration="1.6s" data-wow-delay=".6s">
                <div class="dot testimonial__dot"></div>
            </div>
        </div>
        <div class="swiper testimonial__slider">
            <div class="swiper-wrapper">
                <?php foreach ($all_testimonial_items as $item): ?>
                    <div class="swiper-slide">
                        <div class="testimonial__item">
                            <div class="testimonial__item-head">
                                <div class="testimonial__item-head-info">
                                    <div class="testimonial__item-head-info-image">
                                        <img src="<?php echo $item['main_img']['url']; ?>" alt="image">
                                    </div>
                                    <div class="testimonial__item-head-info-con">
                                        <h3><?php echo $item['name']; ?></h3>
                                        <span><?php echo $item['designation']; ?></span>
                                    </div>
                                </div>
                                <i class="fa-solid fa-quote-right"></i>
                            </div>
                            <div class="testimonial__item-content">
                                <p><?php echo $item['content']; ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Testimonial_One_Widget());
