<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Service_Slider_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-service-slider-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Service Slider', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-post-slider';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'foresty-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => foresty_core()->get_terms_names('service-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'foresty-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'foresty-core'),
                'DESC' => esc_html__('Descending', 'foresty-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'foresty-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'foresty-core'),
                'title' => esc_html__('Title', 'foresty-core'),
                'date' => esc_html__('Date', 'foresty-core'),
                'rand' => esc_html__('Random', 'foresty-core'),
                'comment_count' => esc_html__('Most Comments', 'foresty-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'foresty-core')
        ]);
        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                0 => esc_html__('None', 'foresty-core'),
                9 => esc_html__('Short', 'foresty-core'),
                22 => esc_html__('Regular', 'foresty-core'),
                50 => esc_html__('Long', 'foresty-core'),
            ),
            'default' => 9,
            'description' => esc_html__('select excerpt length', 'foresty-core')
        ]);
        $this->add_control('icon_box_show_hr', [
            'type' => Controls_Manager::DIVIDER,
            'label' => esc_html__( 'icon box show hr', 'foresty-core' ),
        ]);
        $this->add_control(
            'icon_box',
            [
                'label' => esc_html__('Icon Box Show', 'foresty-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('icon box show and hide image', 'foresty-core'),
            ]
        );
        $this->add_control('read-btn', [
            'label' => esc_html__('Read More', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Enter read button text', 'foresty-core'),
            'default' => esc_html__('Details now', 'foresty-core'),
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        
        //setup query
        $args = array(
            'post_type' => 'service',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'service-cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>

        <div class="service-three animal-gallery">
            <div class="container">
                <div class="blog__head-wrp mb-65 position-right-top-2">
                    <div class="arry-btn mt-4 mt-lg-0">
                        <button class="arry-prev animal__arry-prev wow fadeInUp" data-wow-duration="1.6s"
                            data-wow-delay=".6s"><i class="fa-light fa-chevron-left"></i></button>
                        <button class="ms-3 active arry-next animal__arry-next wow fadeInUp" data-wow-duration="1.8s"
                            data-wow-delay=".8s"><i class="fa-light fa-chevron-right"></i></button>
                    </div>
                </div>
                <div class="swiper animal-gallery__slider">
                    <div class="swiper-wrapper">
                        <?php
                        while ($post_data->have_posts()):$post_data->the_post();
                            $post_id = get_the_ID();
                            $img_id = get_post_thumbnail_id($post_id);
                            $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full') : false;
                            $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                        ?>
                        <div class="swiper-slide">
                            <div class="service-three__item animal-gallery__item">
                                <div class="image">
                                    <img src="<?php echo esc_url($img_url); ?>" alt="image">
                                </div>
                                <div class="info text-start">
                                    <h4 class="mb-3"><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                                    <a class="service-three__btn" href="<?php the_permalink(); ?>"><?php echo $settings['read-btn']; ?> <i
                                            class="fa-solid ps-2 fa-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                        <?php
                            endwhile;
                            wp_reset_query();
                        ?>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Service_Slider_Widget());