<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Service_Grid_List_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-service-grid-list-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Service Grid List', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('service_grid', [
            'label' => esc_html__('Service Grid', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'col-lg-3' => esc_html__('col-lg-2', 'foresty-core'),
                'col-lg-3' => esc_html__('col-lg-3', 'foresty-core'),
                'col-lg-4' => esc_html__('col-lg-4', 'foresty-core'),
                'col-lg-6' => esc_html__('col-lg-6', 'foresty-core'),
            ),
            'default' => 'col-lg-4',
            'description' => esc_html__('Select Case Study Grid', 'foresty-core')
        ]);
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'foresty-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => foresty_core()->get_terms_names('service-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'foresty-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'foresty-core'),
                'DESC' => esc_html__('Descending', 'foresty-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'foresty-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'foresty-core'),
                'title' => esc_html__('Title', 'foresty-core'),
                'date' => esc_html__('Date', 'foresty-core'),
                'rand' => esc_html__('Random', 'foresty-core'),
                'comment_count' => esc_html__('Most Comments', 'foresty-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'foresty-core')
        ]);
        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                0 => esc_html__('None', 'foresty-core'),
                9 => esc_html__('Short', 'foresty-core'),
                22 => esc_html__('Regular', 'foresty-core'),
                50 => esc_html__('Long', 'foresty-core'),
            ),
            'default' => 9,
            'description' => esc_html__('select excerpt length', 'foresty-core')
        ]);
        $this->add_control('icon_box_show_hr', [
            'type' => Controls_Manager::DIVIDER,
            'label' => esc_html__( 'icon box show hr', 'foresty-core' ),
        ]);
        $this->add_control(
            'icon_box',
            [
                'label' => esc_html__('Icon Box Show', 'foresty-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('icon box show and hide image', 'foresty-core'),
            ]
        );
        $this->add_control('read-btn', [
            'label' => esc_html__('Read More', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Enter read button text', 'foresty-core'),
            'default' => esc_html__('Read More', 'foresty-core'),
        ]);
        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'foresty-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes to show pagination.', 'foresty-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'pagination_alignment',
            [
                'label' => esc_html__('Pagination Alignment', 'foresty-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left Align', 'foresty-core'),
                    'center' => esc_html__('Center Align', 'foresty-core'),
                    'right' => esc_html__('Right Align', 'foresty-core'),
                ),
                'description' => esc_html__('you can set pagination alignment.', 'foresty-core'),
                'default' => 'left',
                'condition' => array('pagination' => 'yes')
            ]
        );
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];

        //other settings
        $pagination = $settings['pagination'] ? false : true;
        $pagination_alignment = $settings['pagination_alignment'];

        //setup query
        $args = array(
            'post_type' => 'service',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'service-cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>

        <div class="service-list-item-wrap">
            <div class="row">
                <?php while ($post_data->have_posts()):$post_data->the_post(); 

                    //image condition here
                    $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                    $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'foresty_grid_service_12', false) : '';
                    $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                    $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                    $comments_count = get_comments_number(get_the_ID());
                    $comment_text = ($comments_count > 1) ? 'Comments (' . $comments_count . ')' : 'Comment (' . $comments_count . ')';

                    $service_single_meta_data = get_post_meta(get_the_ID(), 'foresty_service_options', true);
                    $service_icon = isset($service_single_meta_data['service_icon']) && !empty($service_single_meta_data['service_icon']) ? $service_single_meta_data['service_icon'] : '';
                    $service_content = isset($service_single_meta_data['service_content']) && !empty($service_single_meta_data['service_content']) ? $service_single_meta_data['service_content'] : '';
                    ?>                    

                    <div class="<?php echo esc_attr($settings['service_grid']); ?> col-md-6">

                        <div class="donation__item blog-two__item bor view__item mb-4">
                            <div class="blog-two__image mb-30">
                                <div class="image">
                                    <img src="<?php echo esc_url($img_url); ?>" alt="image">
                                </div>
                            </div>
                            <h4><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                            <a class="blog-two__item-arrow" href="<?php the_permalink(); ?>"><i class="fa-solid fa-arrow-right"></i></a>
                        </div>
                    </div>

                <?php
                endwhile;
                wp_reset_query();
                ?>
                <?php if (!$pagination) { ?>
                    <div class="col-lg-12">
                        <div class="service-pagination text-<?php echo esc_attr($pagination_alignment) ?> margin-top-20">
                            <?php Foresty()->post_pagination($post_data); ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Service_Grid_List_Widget());