<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Navbar_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-navbar-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Navbar One', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'logo_image', [
                'label' => esc_html__('Logo Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'show_label' => false,
                'description' => esc_html__('Upload Logo image', 'foresty-core'),
            ]
        );
        $this->add_control(
            'btn_text', [
                'label' => esc_html__('Btn text', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Get a quote', 'foresty-core'),
            ]
        );
        $this->add_control(
            'btn_url', [
                'label' => esc_html__('Btn url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core'),
            ]
        );
        $this->add_control(
            'phone_icon',
            [
                'label' => esc_html__('Icon', 'foresty-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'foresty-core'),
                'default' => [
                    'value' => 'fas fa-phone-alt',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'phone_heading', [
                'label' => esc_html__('phone heading', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('call any time', 'foresty-core'),
            ]
        );
        $this->add_control(
            'phone_num', [
                'label' => esc_html__('phone num', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('+91 2659 302 003', 'foresty-core'),
            ]
        );
        $this->add_control(
            'phone_bg_img', [
                'label' => esc_html__('phone bg img', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'show_label' => false,
                'description' => esc_html__('Upload Logo image', 'foresty-core'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'sitebar_settings_section',
            [
                'label' => esc_html__('Sitebar General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sitebar_logo', [
                'label' => esc_html__('Sitebar Logo Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'show_label' => false,
                'description' => esc_html__('Upload Logo image', 'foresty-core'),
            ]
        );
        $this->add_control(
            'sitebar_content', [
                'label' => esc_html__('content', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We appreciate your trust greatly! minim veniam, consectetur adipiscing elit <br> We understand better that enim ad minim veniam, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'foresty-core'),
            ]
        );
        $this->add_control(
            'sitebar_location', [
                'label' => esc_html__('location', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Lavaca Street, Suite 2000', 'foresty-core'),
            ]
        );
        $this->add_control(
            'sitebar_mail', [
                'label' => esc_html__('location', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('trustemail@.com', 'foresty-core'),
            ]
        );
        $this->add_control(
            'sitebar_phone', [
                'label' => esc_html__('location', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('(+880) 01235 70051', 'foresty-core'),
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'sitebar_icon', [
                'label' => esc_html__('icon', 'foresty-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-twitter',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'sitebar_url', [
                'label' => esc_html__('url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core')
            ]
        );
        $this->add_control('sitebar_social_items', [
            'label' => esc_html__('sitebar social Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $sitebar_social_items = $settings['sitebar_social_items'];
        ?>

        <div class="body-overlay" id="body-overlay"></div>
        <!--sidebar menu start-->
        <div class="sidebar-menu" id="sidebar-menu">
            <button class="sidebar-menu-close"><i class="fa fa-times"></i></button>
            <div class="sidebar-inner">
                <div class="thumb mb-5">
                    <img src="<?php echo $settings['sitebar_logo']['url']; ?>" alt="logo"/>
                </div>
                <p>
                    <?php
                        $sitebar_content = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['sitebar_content']);
                        print wp_kses($sitebar_content, foresty_core()->kses_allowed_html('all'));
                    ?>
                </p>
                <div class="sidebar-address">
                    <h4 class="mb-3 pt-xl-4"><?php echo esc_html('Contact Us', 'foresty-core'); ?></h4>
                    <ul>
                        <li><i class="fa fa-map-marker-alt"></i><?php echo $settings['sitebar_location']; ?></li>
                        <li><i class="fa fa-envelope"></i><?php echo $settings['sitebar_mail']; ?></li>
                        <li><i class="fa fa-phone"></i><?php echo $settings['sitebar_phone']; ?></li>
                    </ul>
                </div>
                <h4 class="mb-4 pt-xl-4"><?php echo esc_html('Social Contact', 'foresty-core'); ?></h4>
                <ul class="social-media sitebar-social-media p-0 m-0">
                    <?php foreach ($sitebar_social_items as $items) { ?>
                        <li>
                            <a href="<?php echo $items['sitebar_url']; ?>">
                                <?php Icons_Manager::render_icon($items['sitebar_icon'], ['aria-hidden' => 'true']); ?>
                            </a>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
        <!--sidebar menu end-->

        <div class="navbar-area-1 border-bottom-1">
            <div class="row g-0">
                <div class="col-lg-3 d-none d-lg-block">
                    <div class="logo d-inline-block">
                        <a href="<?php echo esc_url(get_home_url()); ?>"><img src="<?php echo $settings['logo_image']['url']; ?>" alt="logo"></a>
                    </div>
                    <div class="detail-bar d-inline-block d-xl-inline-block d-lg-none" id="navigation-button">
                        <svg width="47" height="46" viewBox="0 0 47 46" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="3.03711" cy="3" r="3" fill="#4BAF47"/>
                            <circle cx="23.0371" cy="3" r="3" fill="#4BAF47"/>
                            <circle cx="43.0371" cy="3" r="3" fill="#4BAF47"/>
                            <circle cx="43.0371" cy="23" r="3" fill="#4BAF47"/>
                            <circle cx="23.0371" cy="23" r="3" fill="#4BAF47"/>
                            <circle cx="3.03711" cy="23" r="3" fill="#4BAF47"/>
                            <circle cx="3.03711" cy="43" r="3" fill="#4BAF47"/>
                            <circle cx="23.0371" cy="43" r="3" fill="#4BAF47"/>
                            <circle cx="43.0371" cy="43" r="3" fill="#4BAF47"/>
                        </svg>
                    </div>
                </div>
                <div class="col-lg-6">
                    <nav class="navbar navbar-area navbar-expand-lg navigation-style-01 navbar-style-01 navbar-default">
                        <div class="container custom-container">
                            <div class="responsive-mobile-menu d-lg-none d-lg-inline-block">
                                <div class="logo-wrapper">
                                    <?php
                                    $header_one_logo = cs_get_option('header_one_logo');
                                    if (has_custom_logo() && empty($header_one_logo['id'])) {
                                        the_custom_logo();
                                    } elseif (!empty($header_one_logo['id'])) {
                                        printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_one_logo['url'], $header_one_logo['alt']);
                                    } else {
                                        printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                                    }
                                    ?>
                                </div>
                                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#foresty_main_menu" aria-controls="foresty_main_menu" aria-expanded="false" aria-label="Toggle navigation">
                                    <span class="navbar-toggler-icon"></span>
                                </button>
                            </div>
                            <?php 
                                wp_nav_menu(array(
                                    'theme_location' => 'main-menu',
                                    'menu_class' => 'navbar-nav text-lg-center',
                                    'container' => 'div',
                                    'container_class' => 'collapse navbar-collapse',
                                    'container_id' => 'foresty_main_menu',
                                    'fallback_cb' => 'foresty_theme_fallback_menu',
                                ));
                            ?>
                        </div>
                    </nav>
                </div>
                <div class="col-lg-3 text-end  d-none d-lg-block">
                    <div class="border-left-1 d-inline-block">
                        <a class="quote-btn d-xl-inline-block d-lg-none" href="<?php echo $settings['btn_url']; ?>">
                            <?php echo $settings['btn_text']; ?>
                            <i class="fa fa-angle-double-right"></i>
                        </a>
                        <div class="d-inline-block" style="background-image: url('<?php echo $settings['phone_bg_img']['url']; ?>');">
                            <div class="media text-start">
                                <div class="media-left align-self-center">
                                    <?php Icons_Manager::render_icon($settings['phone_icon'], ['aria-hidden' => 'true']); ?>
                                </div>
                                <div class="media-body">
                                    <?php echo $settings['phone_heading']; ?> <br>
                                    <span><?php echo $settings['phone_num']; ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- back to top start -->
        <?php
            $back_top_enable = cs_get_switcher_option('back_top_enable');
            $back_top_icon = cs_get_option('back_top_icon') ? cs_get_option('back_top_icon') : 'fas fa-angle-up';
            if (!$back_top_enable) {
                return;
            } 
        ?>
        <div class="back-to-top">
            <span class="back-top"><i class="<?php echo esc_attr($back_top_icon); ?>"></i></span>
        </div>
        <!-- back to top end -->

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Navbar_One_Widget());