<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Navbar_Four_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-navbar-four-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Navbar four', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'logo_image', [
                'label' => esc_html__('Logo Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'show_label' => false,
                'description' => esc_html__('Upload Logo image', 'foresty-core'),
            ]
        );
        $this->add_control(
            'mail', [
                'label' => esc_html__('Email', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__(' Info.Company@Gmail.Com', 'foresty-core'),
            ]
        );
        $this->add_control(
            'location', [
                'label' => esc_html__('location', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('85 Ketch Harbour RoadBensalem, PA 19020', 'foresty-core'),
            ]
        );
        $this->add_control(
            'btn_text', [
                'label' => esc_html__('Btn text', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Get a quote', 'foresty-core'),
            ]
        );
        $this->add_control(
            'btn_url', [
                'label' => esc_html__('Btn url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'ht_icon', [
                'label' => esc_html__('icon', 'foresty-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-twitter',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'ht_url', [
                'label' => esc_html__('url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core')
            ]
        );
        $this->add_control('ht_social_items', [
            'label' => esc_html__('ht social Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $ht_social_items = $settings['ht_social_items'];
        ?>

        <div class="body-overlay" id="body-overlay"></div>
        <div class="topbar-area d-lg-block d-none px-xl-3">  
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <ul class="topbar-inner-list"> 
                            <?php if (!empty($settings['mail'])) { ?>
                                <li><i class="fa fa-paper-plane"></i><?php echo esc_html($settings['mail']); ?></li>
                            <?php } ?>
                            <?php if (!empty($settings['location'])) { ?>
                                <li><i class="fa fa-map-marker-alt"></i><?php echo esc_html($settings['location']); ?></li>
                            <?php } ?>
                        </ul>   
                    </div>
                    <div class="col-lg-4">
                        <ul class="topbar-socail-list p-0 m-0 text-lg-end">
                            <?php foreach ($ht_social_items as $items) { ?>
                                <li>
                                    <a href="<?php echo $items['ht_url']; ?>">
                                        <?php
                                            Icons_Manager::render_icon($items['ht_icon'], ['aria-hidden' => 'true']);
                                        ?>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="navbar-area-5 bg-white">
            <div class="container p-0">
                <div class="row">
                    <div class="col-xl-9 col-lg-8">
                        <nav class="navbar navbar-area navbar-expand-lg navigation-style-01 navbar-style-01 navbar-default p-2 px-0">
                            <div class="container custom-container">
                                <div class="responsive-mobile-menu">
                                    <div class="logo-wrapper ps-xl-4">
                                        <?php
                                        if (!empty($settings['logo_image']['url'])) { ?>
                                            <a href="<?php echo esc_url(get_home_url()); ?>"><img src="<?php echo $settings['logo_image']['url']; ?>" alt="logo"></a>
                                        <?php }else {
                                            $header_one_logo = cs_get_option('header_one_logo');
                                            if (has_custom_logo() && empty($header_one_logo['id'])) {
                                                the_custom_logo();
                                            } elseif (!empty($header_one_logo['id'])) {
                                                printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_one_logo['url'], $header_one_logo['alt']);
                                            } else {
                                                printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                                            }
                                        }
                                        ?>
                                    </div>
                                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#foresty_main_menu" aria-controls="foresty_main_menu" aria-expanded="false" aria-label="Toggle navigation">
                                        <span class="navbar-toggler-icon"></span>
                                    </button>
                                </div>
                                <?php 
                                    wp_nav_menu(array(
                                        'theme_location' => 'main-menu',
                                        'menu_class' => 'navbar-nav text-lg-end bg-white',
                                        'container' => 'div',
                                        'container_class' => 'collapse navbar-collapse',
                                        'container_id' => 'foresty_main_menu',
                                        'fallback_cb' => 'foresty_theme_fallback_menu',
                                    ));
                                ?>
                            </div>
                        </nav>
                    </div>
                    <div class="col-xl-3 col-lg-4 d-lg-block d-none text-end align-self-center">
                        <div class="d-inline-block">
                            <a class="btn btn-base d-xl-inline-block d-lg-none" href="<?php echo $settings['btn_url']; ?>">
                                <span><?php echo $settings['btn_text']; ?></span>
                                <i class="fa fa-angle-double-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- back to top start -->
        <?php
            $back_top_enable = cs_get_switcher_option('back_top_enable');
            $back_top_icon = cs_get_option('back_top_icon') ? cs_get_option('back_top_icon') : 'fas fa-angle-up';
            if (!$back_top_enable) {
                return;
            } 
        ?>
        <div class="back-to-top">
            <span class="back-top"><i class="<?php echo esc_attr($back_top_icon); ?>"></i></span>
        </div>
        <!-- back to top end -->

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Navbar_Four_Widget());