<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Footer_Info_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-footer-info-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Footer Info', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('footer_info_logo',
            [
                'label' => esc_html__('logo', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control(
            'footer_info_shortcode',
            [
                'label' => esc_html__('shortcode', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core')
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'footer_info_icon', [
                'label' => esc_html__('icon', 'foresty-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-twitter',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'footer_info_url', [
                'label' => esc_html__('url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core')
            ]
        );
        $this->add_control('footer_info_social_items', [
            'label' => esc_html__('sitebar social Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $footer_info_social_items = $settings['footer_info_social_items'];
        ?>

        <div class="our-info">
            <div class="container">
                <div class="row align-items-center">
                    <?php if (!empty($settings['footer_info_logo']['url'])) { ?>
                        <div class="col-lg-3 wow fadeInUp" data-wow-duration="1.4s" data-wow-delay=".4s">
                            <a href="<?php echo esc_url(get_home_url()); ?>" class="our-info__logo mb-4 mb-lg-0">
                                <img src="<?php echo $settings['footer_info_logo']['url']; ?>" alt="<?php echo esc_html('logo', 'foresty-core'); ?>">
                            </a>
                        </div>
                    <?php } ?>
                    <?php if (!empty($settings['footer_info_shortcode'])) { ?>
                        <div class="mt-lg-0 mt-4 mb-xl-0 mb-4 col-lg-5 wow fadeInDown" data-wow-duration="1.6s" data-wow-delay=".6s">
                            <?php echo do_shortcode($settings['footer_info_shortcode']); ?>
                        </div>
                    <?php } ?>
                    <?php  if (!empty($footer_info_social_items)) { ?>
                        <div class="col-lg-4">
                            <div class="our-info__social-icon float-lg-end float-none mt-4 mt-lg-0">
                                <?php foreach ($footer_info_social_items as $social_item) { ?>
                                    <a href="<?php echo esc_url($social_item['footer_info_url'], 'foresty'); ?>" target="_blank">
                                        <?php Icons_Manager::render_icon($social_item['footer_info_icon'], ['aria-hidden' => 'true']); ?>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Footer_Info_Widget());