<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Event_Speaker_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-event-speaker-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Event Speaker', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('main_img',
            [
                'label' => esc_html__('Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control(
            'name',
            [
                'label' => esc_html__('name', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter name.', 'foresty-core'),
                'default' => esc_html__('Alyssa P. Scribner', 'foresty-core')
            ]
        );
        $this->add_control(
            'designation',
            [
                'label' => esc_html__('designation', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter designation.', 'foresty-core'),
                'default' => esc_html__('Hinkle Deegan', 'foresty-core')
            ]
        );
        $this->add_control('content',
            [
                'label' => esc_html__('Content', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Neque Porro Est Qui Dolorem Ipsum Quia Quaed Inventor Veritatis Et Quasi Architecto Beatae Vitae Dicta Sunt Explicabo. Aelltes Port Lacus Quis Enim', 'foresty-core')
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            's_icon', [
                'label' => esc_html__('icon', 'foresty-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-twitter',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            's_url', [
                'label' => esc_html__('url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core')
            ]
        );
        $this->add_control('s_contact_items', [
            'label' => esc_html__('Contact Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $s_contact_items = $settings['s_contact_items'];
        ?>

        <div class="event-single__speaker">
            <div class="speaker-item p-4 bor mb-3">
                <div class="d-flex flex-wrap flex-sm-nowrap gap-4 align-items-center">
                    <div class="image-wrp">
                        <div class="image">
                            <img src="<?php echo $settings['main_img']['url']; ?>" alt="image">
                        </div>
                    </div>
                    <div class="content">
                        <div class="speaker-item-head bor-bottom pb-20 mb-25">
                            <div class="author-name">
                                <h4><a href="#0"><?php echo $settings['name']; ?></a></h4>
                                <span><?php echo $settings['designation']; ?></span>
                            </div>
                            <div class="social-icon mt-4 mt-md-0">
                                <?php foreach ($s_contact_items as $items) { ?>
                                    <a href="<?php echo $items['s_url']; ?>">
                                        <?php
                                            Icons_Manager::render_icon($items['s_icon'], ['aria-hidden' => 'true']);
                                        ?>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
                        <p><?php echo $settings['content']; ?></p>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Event_Speaker_Widget());