<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Event_List_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-event_list-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Event list One', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control('main_img',
            [
                'label' => esc_html__('Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $repeater->add_control(
            'img_date', [
                'label' => esc_html__('img_date', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('15 JUN', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'main_date', [
                'label' => esc_html__('main date', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Dec 13, 2024 @ 10:00 Am', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('title', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Would You Like To See A Real Leopard Live?', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('main date', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Important To Note That The Concept Of Zoos Has Evolved Over Time. In The Past, Some ZoosFocused More On Entertainment And Less On Conservation And Animal Welfare', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'organizer', [
                'label' => esc_html__('organizer', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Ashton Porter', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'venue', [
                'label' => esc_html__('venue', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('350 5th AveNew York, NY 10118 United States', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'location', [
                'label' => esc_html__('location', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d29581.552527417!2d-77.04440883230183!3d38.80089850193032!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89b7b0f02c6539a9%3A0xacc6091466dd9068!2s901%20N%20Pitt%20St%20Suite%20170%2C%20Alexandria%2C%20VA%2022314%2C%20USA!5e0!3m2!1sen!2sbd!4v1694324425557!5m2!1sen!2sbd', 'foresty-core')
            ]
        );
		$repeater->add_control(
            'btn_url', [
                'label' => esc_html__('btn url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core')
            ]
        );
        $this->add_control('event_list_items', [
            'label' => esc_html__('event list Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $event_list_items = $settings['event_list_items'];
        ?>

        <div class="event">
            <?php foreach ($event_list_items as $items) { ?>
                <div class="event__item-scroll mb-30 wow fadeInUp" data-wow-duration="1.2s" data-wow-delay=".2s">
                    <div class="row g-5 g-lg-0 align-items-center">
                        <div class="col-lg-4 align-items-center">
                            <div class="event__image">
                                <img src="<?php echo $items['main_img']['url']; ?>" alt="image">
                                <span class="event-tag"><?php echo $items['img_date']; ?></span>
                            </div>
                        </div>
                        <div class="col-lg-8 align-items-center">
                            <div class="event__content">
                                <span class="time"><i class="fa-solid fa-clock"></i> <?php echo $items['main_date']; ?></span>
								<h3 class="mt-20 mb-20"><a href="<?php echo $items['btn_url']; ?>"><?php echo $items['title']; ?></a></h3>
                                <p class="pb-30 bor-bottom mb-30"><?php echo $items['content']; ?></p>
                                <div class="event-info">
                                    <ul>
                                        <li>
                                            <h5>Organizer</h5>
                                            <p><?php echo $items['organizer']; ?></p>
                                        </li>
                                        <li>
                                            <h5>
                                                Venue
                                            </h5>
                                            <a href="#0"><?php echo $items['venue']; ?></a>
                                        </li>
                                        <li>
                                            <a class="map-popup"
                                                href="<?php echo $items['location']; ?>">+
                                                Google Map</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Event_List_One_Widget());