<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Event_Details_Info_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-event-details-info-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('event details info', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('main_img',
            [
                'label' => esc_html__('Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'e_icon', [
                'label' => esc_html__('icon', 'foresty-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-twitter',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'e_title', [
                'label' => esc_html__('title', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Event Location', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'e_subtitle', [
                'label' => esc_html__('sub title', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('901 N Pitt Str, Suite 170 Alexandria, USA', 'foresty-core')
            ]
        );
        $this->add_control('contact_items', [
            'label' => esc_html__('Contact Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $contact_items = $settings['contact_items'];
        ?>

        <div class="event-single__right-item bor p-4">
            <ul class="right-item-list p-0 m-0">
                <?php foreach ($contact_items as $items) { ?>
                    <li class="pb-30">
                        <?php
                            Icons_Manager::render_icon($items['e_icon'], ['aria-hidden' => 'true']);
                        ?>
                        <a href="#0">
                            <h5 class="mb-2"><?php echo $items['e_title']; ?></h5>
                            <?php echo $items['e_subtitle']; ?>
                        </a>
                    </li>
                <?php } ?>
            </ul>
            <div class="image">
                <img src="<?php echo $settings['main_img']['url']; ?>" alt="image">
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Event_Details_Info_Widget());