<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Donation_Slider_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-donation-slider-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Donation Slider', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('donation_grid', [
            'label' => esc_html__('Donation Grid', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'col-lg-3' => esc_html__('col-lg-2', 'foresty-core'),
                'col-lg-3' => esc_html__('col-lg-3', 'foresty-core'),
                'col-lg-4' => esc_html__('col-lg-4', 'foresty-core'),
                'col-lg-6' => esc_html__('col-lg-6', 'foresty-core'),
            ),
            'default' => 'col-lg-4',
            'description' => esc_html__('Select Case Study Grid', 'foresty-core')
        ]);
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'foresty-core'),
                'DESC' => esc_html__('Descending', 'foresty-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'foresty-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'foresty-core'),
                'title' => esc_html__('Title', 'foresty-core'),
                'date' => esc_html__('Date', 'foresty-core'),
                'rand' => esc_html__('Random', 'foresty-core'),
                'comment_count' => esc_html__('Most Comments', 'foresty-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'foresty-core')
        ]);
        $this->end_controls_section();
		
		$this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Nabnar style Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('donation_progress_bg_color', [
            'label' => esc_html__('Donation Progress Bg Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .donation__item-progress-bar::after" => "background: {{VALUE}} !important"
            ]
        ]);
		$this->add_control('donation_read_more_color', [
            'label' => esc_html__('donation read more Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .donation__item-arrow::before" => "color: {{VALUE}}",
				"{{WRAPPER}} .donation__item-arrow" => "color: {{VALUE}}",
			],
        ]);
		$this->add_control('donation_title_color', [
            'label' => esc_html__('donation title Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .donation__item h4 a:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        // $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];

        //setup query
        $args = array(
            'post_type' => 'give_forms',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        $post_data = new \WP_Query($args);
        ?>

        <div class="swiper donation__slider">
            <div class="swiper-wrapper">
                <?php 
                    $i = 1;
                    while ($post_data->have_posts()):$post_data->the_post(); 
                    $i++;
                    //image condition here
                    $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                    $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'foresty_grid_donation_12', false) : '';
                    $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                    $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                    //give control here
                    $form  = new \Give_Donate_Form( get_the_ID() );
                    $goal_progress_stats = give_goal_progress_stats( $form );
                    $income = $goal_progress_stats['raw_actual'];
                    $goal   = $goal_progress_stats['raw_goal'];
                    $progress = $goal ? round( ( $income / $goal ) * 100, 2 ) : 0;
                    $progress_bar_value = $income >= $goal ? 100 : $progress;
                    $sales = $form->get_sales();
                    $sales = ( !empty($sales) ? $sales : 0 );

                    //currency control here
                    $form_currency = apply_filters( 'give_goal_form_currency', give_get_currency( get_the_ID() ), get_the_ID() );
                    $income_format_args = apply_filters( 'give_goal_income_format_args', array(
                        'sanitize' => false,
                        'currency' => $form_currency,
                        'decimal'  => false,
                    ), get_the_ID() );
                    $goal_format_args = apply_filters( 'give_goal_amount_format_args', array(
                        'sanitize' => false,
                        'currency' => $form_currency,
                        'decimal'  => false,
                    ), get_the_ID() );
                    $income = give_human_format_large_amount( give_format_amount( $income, $income_format_args ), array( 'currency' => $form_currency ) );
                    $goal   = give_human_format_large_amount( give_format_amount( $goal, $goal_format_args ), array( 'currency' => $form_currency ) );
                    $foresty_raised = give_currency_filter( $income, array( 'form_id' => get_the_ID() ) );
                    $foresty_goal = give_currency_filter( $goal, array( 'form_id' => get_the_ID() ) );

                ?>   

                    <div class="swiper-slide">
                        <div class="donation__item">
                            <div class="image mb-30">
                                <?php
                                    if (!empty($img_url)) { ?>
                                        <img src="<?php echo esc_url($img_url); ?>" alt="image">
                                    <?php }else { ?>
                                        <img src="<?php echo get_template_directory_uri().'/assets/img/'.$i.'.jpg'; ?>" alt="image">
                                    <?php }
                                ?>
                            </div>
                            <div class="donation__item-progress-wrp">
                                <div class="d-flex align-items-center justify-content-between">
                                    <h6>
                                        <?php echo esc_html('Goal :', 'foresty-core'); ?>
                                        <?php echo esc_html($foresty_goal); ?>
                                    </h6>
                                    <h6>
                                        <?php echo esc_html('Raised :', 'foresty-core'); ?>
                                        <?php echo esc_html($foresty_raised); ?> 
                                    </h6>
                                </div>
                                <div class="donation__item-progress-bar"></div>
                            </div>
                            <h4><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                            <a class="donation__item-arrow" href="<?php the_permalink(); ?>">
                                <i class="fa-solid fa-arrow-right"></i>
                            </a>
                        </div>
                    </div> 
                <?php
                    endwhile;
                    wp_reset_query();
                ?>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Donation_Slider_Widget());