<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Case_Study_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-case-study-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Case Study One', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'subtitle', [
                'label' => esc_html__('subtitle', 'exgrid-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('OUR CASE STUDY', 'exgrid-core')
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__('title', 'exgrid-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Successfully Completed Projects For Our Clients', 'exgrid-core')
            ]
        );
        $this->add_control(
            'content', [
                'label' => esc_html__('content', 'exgrid-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('We Are An Organization Engaged In "Tree Planting" Activities, Therefore You Can "Donate Trees. We Also Join In "Community Forestry | Reforestation" To Keep The Earth Together So That It Remains Sustainable.', 'exgrid-core')
            ]
        );
        $this->add_control('shape_img',
            [
                'label' => esc_html__('Main Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'title', [
                'label' => esc_html__('title', 'exgrid-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Carbon Offsetting', 'exgrid-core')
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('content', 'exgrid-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Tree planting is the act of planting young trees, shrubs, or other woody plants into the ground to establish new forests or enhance existing ones. It is a crucial component of environmental', 'exgrid-core')
            ]
        );
        $repeater->add_control('main_img',
            [
                'label' => esc_html__('Main Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('case_study_one_items', [
            'label' => esc_html__('tab one Item', 'exgrid-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $case_study_one_items = $settings['case_study_one_items'];
        ?>

        <section class="project pt-130 pb-130">
            <div class="project__wrp">
                <?php if (!empty($settings['shape_img']['url'])) { ?> 
                    <div class="project__wrp-shape sway_Y__animation d-none d-md-block">
                        <img src="<?php echo $settings['shape_img']['url']; ?>" alt="shape">
                    </div>
                <?php } ?>
                <div class="swiper have-bg project-slider d-none d-lg-block">
                    <div class="swiper-wrapper">
                        <?php foreach ($case_study_one_items as $item): ?>
                            <div class="swiper-slide">
                                <div class="project__image bg-image"
                                    style="background-image: url(<?php echo $item['main_img']['url']; ?>);">
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="container">
                    <div class="row justify-content-end">
                        <div class="col-lg-6 ps-4 bor-left py-lg-5">
                            <div class="section-header theme-heading-title pr-20">
                                <h5 class="subtitle wow fadeInUp" data-wow-duration="1.2s" data-wow-delay=".2s">
                                    <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_0_4338)">
                                        <path d="M17.3765 0.653721C17.1421 0.419863 16.8588 0.240914 16.5468 0.129768C16.2349 0.0186233 15.9023 -0.0219503 15.5728 0.0109712C13.478 0.213471 6.4333 1.08572 3.7123 3.80372C2.41163 5.10794 1.64035 6.84784 1.5474 8.68743C1.45446 10.527 2.04645 12.3358 3.20905 13.7645L11.504 5.46947C11.6455 5.33285 11.8349 5.25726 12.0316 5.25897C12.2282 5.26068 12.4163 5.33955 12.5554 5.47861C12.6945 5.61766 12.7733 5.80577 12.775 6.00242C12.7768 6.19907 12.7012 6.38852 12.5645 6.52997L4.27255 14.825C5.70072 15.9883 7.50935 16.581 9.34903 16.4886C11.1887 16.3962 12.9289 15.6253 14.2333 14.3247C16.9903 11.567 17.8333 4.54397 18.0275 2.45747C18.0593 2.12738 18.0174 1.79435 17.9048 1.48242C17.7922 1.17049 17.6118 0.887451 17.3765 0.653721ZM3.7123 14.3247C3.8913 14.5032 4.07705 14.671 4.26955 14.828L1.31455 17.783C1.17272 17.9192 0.983041 17.9944 0.786369 17.9921C0.589697 17.9899 0.401777 17.9105 0.263093 17.771C0.12441 17.6315 0.0460642 17.4431 0.0449343 17.2465C0.0438044 17.0498 0.119981 16.8605 0.257053 16.7195L3.21205 13.7645C3.36905 13.9565 3.5358 14.1432 3.7123 14.3247Z" fill="#4BAF47"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_0_4338">
                                        <rect width="18" height="18" fill="white" transform="translate(0.0371094)"/>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                    <?php echo $settings['subtitle']; ?>
                                </h5>
                                <h2 class="wow fadeInUp" data-wow-duration="1.4s" data-wow-delay=".4s"><?php echo $settings['title']; ?></h2>
                                <p class="wow fadeInUp" data-wow-duration="1.6s" data-wow-delay=".6s"><?php echo $settings['content']; ?></p>
                            </div>
                            <div class="arry-btn mb-4 d-block d-lg-none">
                                <button class="arry-prev project-arry-prev"><i
                                        class="fa-light fa-chevron-left"></i></button>
                                <button class="ms-3 active arry-next project-arry-next"><i
                                        class="fa-light fa-chevron-right"></i></button>
                            </div>
                            <div class="row g-3">
                                <div class="col-sm-4">
                                    <div class="wrp">
                                        <div class="pegi-number pt-4">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-8">
                                    <div class="swiper project-slider2">
                                        <div class="swiper-wrapper">
                                            <?php foreach ($case_study_one_items as $item): ?>
                                                <div class="swiper-slide">
                                                    <div class="project__item">
                                                        <h4><?php echo $item['title']; ?></h4>
                                                        <p><?php echo $item['content']; ?></p>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="arry-btn mt-65 d-none d-lg-block">
                                <button class="arry-prev project-arry-prev"><i
                                        class="fa-light fa-chevron-left"></i></button>
                                <button class="ms-3 active arry-next project-arry-next"><i
                                        class="fa-light fa-chevron-right"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
        </section>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Case_Study_One_Widget());