<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Button_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-button-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Button', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('btn_text', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('More About us', 'foresty-core'),
        ]);
        $this->add_control('btn_url', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('#', 'foresty-core'),
        ]);
        $this->add_control(
            'btn_icon_position',
            [
                'label' => esc_html__('btn icon position', 'foresty-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'right',
                'options' => [
                    'left' => esc_html__('Icon Left', 'foresty-core'),
                    'right' => esc_html__('Icon Right', 'foresty-core'),
                ],
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__('Icon Selector', 'foresty-core'),
                'type' => Controls_Manager::SELECT,
                'default' => [
                    'value' => 'fa fa-angles-right',
                    'library' => 'solid',
                ],
                'options' => [
                    'text_icon' => esc_html__('Text Icon', 'foresty-core'),
                    'icon' => esc_html__('Icon', 'foresty-core'),
                ],

            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Styling Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('border_color', [
            'label' => esc_html__('border Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn_wrap .btn-one" => "border-color: {{VALUE}}"
            ]
        ]);
		$this->add_control('border_text_color', [
            'label' => esc_html__('border Text Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn_wrap .btn-one span" => "color: {{VALUE}}"
            ]
        ]);
		$this->add_control('border_icon_color', [
            'label' => esc_html__('border Icon Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn_wrap .btn-one" => "color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $btn_icon_position = $settings['btn_icon_position'];
        ?>

        <div class="btn_wrap">
            <a href="<?php echo $settings['btn_url']; ?>" class="btn-one mt-35">
                <?php if ($btn_icon_position == 'left') {
                    Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']);
                } ?> 
                <span><?php echo $settings['btn_text']; ?></span> 
                <?php if ($btn_icon_position == 'right') {
                    Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']);
                } ?>
            </a>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Button_Widget());