<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Blog_Post_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-blog-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Blog: Slider 01', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'column',
            [
                'label' => esc_html__('Column', 'foresty-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '6' => esc_html__('02 Column', 'foresty-core'),
                    '3' => esc_html__('04 Column', 'foresty-core'),
                    '4' => esc_html__('03 Column', 'foresty-core'),
                    '2' => esc_html__('06 Column', 'foresty-core')
                ),
                'description' => esc_html__('select grid column', 'foresty-core'),
                'default' => '6'
            ]
        );
        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'foresty-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes to show pagination.', 'foresty-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'pagination_alignment',
            [
                'label' => esc_html__('Pagination Alignment', 'foresty-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left Align', 'foresty-core'),
                    'center' => esc_html__('Center Align', 'foresty-core'),
                    'right' => esc_html__('Right Align', 'foresty-core'),
                ),
                'description' => esc_html__('you can set pagination alignment.', 'foresty-core'),
                'default' => 'left',
                'condition' => array('pagination' => 'yes')
            ]
        );
        $this->add_control('read-btn', [
            'label' => esc_html__('Read More', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter read button text', 'foresty-core'),
            'default' => esc_html__('Read More', 'foresty-core')
        ]);
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'foresty-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => foresty_core()->get_terms_names('category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'foresty-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'foresty-core'),
                'DESC' => esc_html__('Descending', 'foresty-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'foresty-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'foresty-core'),
                'title' => esc_html__('Title', 'foresty-core'),
                'date' => esc_html__('Date', 'foresty-core'),
                'rand' => esc_html__('Random', 'foresty-core'),
                'comment_count' => esc_html__('Most Comments', 'foresty-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'foresty-core')
        ]);
        $this->end_controls_section();
		
		$this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Nabnar style Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('blog_cat_color', [
            'label' => esc_html__('blog cat Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .blog__item-right span" => "color: {{VALUE}} !important",
            ]
        ]);
		$this->add_control('blog_title_hover_color', [
            'label' => esc_html__('blog title hover Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .blog__item-left-content h4 a:hover" => "color: {{VALUE}}",
			],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        //other settings
        $pagination = $settings['pagination'] ? false : true;
        $pagination_alignment = $settings['pagination_alignment'];
        //setup query
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>

        <div class="blog__item-left">
            <div class="swiper blog__slider">
                <div class="swiper-wrapper">
                    <?php 
                        while ($post_data->have_posts()):$post_data->the_post();
                        $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                        $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'foresty_grid', false) : '';
                        $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                        $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
                        $comments_count = get_comments_number(get_the_ID());
                        $comment_text = ($comments_count > 1) ? $comments_count . ' Comments' . '' : $comments_count . ' Comment' . '';
                    ?>
                    <div class="swiper-slide">
                        <div class="row g-4">
                            <div class="col-md-5">
                                <div class="blog__item-left-content">
                                    <span class="blog__tag">Environment</span>
                                    <h4><a href="<?php the_permalink() ?>"><?php echo get_the_title(); ?></a></h4>
                                    <p><?php print wp_trim_words( get_the_content(), 17, null ); ?></p>
                                    <span class="blog__item-left-content-info">
                                        By <strong> <?php foresty()->posted_by(); ?> </strong> 
                                        <?php echo esc_html($comment_text); ?>
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="image">
                                    <img src="<?php echo esc_url($img_url)?>" alt="<?php echo $img_alt?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    endwhile;
                    wp_reset_query();
                    ?>
                </div>
            </div>
            <div class="blog__item-left-dot-wrp d-lg-inline-block d-none">
                <div class="dot blog__dot"></div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Blog_Post_Slider_One_Widget());