<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Blog_Post_Slider_LIst_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-blog-list-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Blog: List Item', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('read-btn', [
            'label' => esc_html__('Read More', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter read button text', 'foresty-core'),
            'default' => esc_html__('Read More', 'foresty-core')
        ]);
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'foresty-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => foresty_core()->get_terms_names('category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'foresty-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'foresty-core'),
                'DESC' => esc_html__('Descending', 'foresty-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'foresty-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'foresty-core'),
                'title' => esc_html__('Title', 'foresty-core'),
                'date' => esc_html__('Date', 'foresty-core'),
                'rand' => esc_html__('Random', 'foresty-core'),
                'comment_count' => esc_html__('Most Comments', 'foresty-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'foresty-core')
        ]);
        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'foresty-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                25 => esc_html__('Short', 'foresty-core'),
                55 => esc_html__('Regular', 'foresty-core'),
                100 => esc_html__('Long', 'foresty-core'),
            ),
            'default' => 25,
            'description' => esc_html__('select excerpt length', 'foresty-core')
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'title_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'foresty-core'),
            ]
        );
        $this->add_control('normal_post_title_color', [
            'label' => esc_html__('Title Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-list-items .content .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_post_paragraph_color', [
            'label' => esc_html__('Meta Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-list-items .content .author-meta li" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_post_border_color', [
            'label' => esc_html__('Border Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-list-items + .news-single-list-items" => "border-color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'foresty-core'),
            ]
        );

        $this->add_control('hover_post_title_color', [
            'label' => esc_html__('Title Color', 'foresty-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-list-items .content .title:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'typography_settings_section',
            [
                'label' => esc_html__('Typography Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'foresty-core'),
            'name' => 'post_meta_typography',
            'description' => esc_html__('select title typography', 'foresty-core'),
            'selector' => "{{WRAPPER}} .news-single-list-items .content .title"
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Meta Typography', 'foresty-core'),
            'name' => 'category_typography',
            'description' => esc_html__('select Meta typography', 'foresty-core'),
            'selector' => "{{WRAPPER}} .news-single-list-items .content .author-meta li"
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        //other settings

        //setup query
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>
        <div class="blog-list-item-wrapper">
            <?php
            while ($post_data->have_posts()):$post_data->the_post();
                ?>
                <div class="news-single-list-items">
                    <div class="content">
                        <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        <ul class="author-meta">
                            <li>
                                <?php foresty()->posted_by(); ?>
                            </li>
                            <li>
                                <?php foresty()->posted_on(); ?>
                            </li>
                        </ul>
                    </div>
                </div>
            <?php
            endwhile;
            wp_reset_query();
            ?>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Blog_Post_Slider_LIst_Widget());