<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Banner_Three_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-banner-three-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner Three', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control('main_img',
            [
                'label' => esc_html__('Main Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $repeater->add_control(
            'subtitle',
            [
                'label' => esc_html__('sub Title', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('A force of Nature', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('Working Towards A Sustainable World', 'foresty-core')
            ]
        );
        $repeater->add_control('btn_text', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Discover With Us', 'foresty-core'),
        ]);
        $repeater->add_control('btn_url', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('#', 'foresty-core'),
        ]);
        $this->add_control('banner_items', [
            'label' => esc_html__('banner Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $banner_items = $settings['banner_items'];
        ?>

        <div class="banner-three banner-five mt-30 ml-30 pr-30">
            <div class="swiper banner-three__slider banner-five__slider">
                <div class="swiper-wrapper">
                    <?php foreach ($banner_items as $items) { ?>
                    <div class="swiper-slide">
                        <div class="slide-bg bg-cover" style="background-image: url('<?php echo $items['main_img']['url']; ?>');"></div>
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-7">
                                    <div class="banner-three__content banner-five__content">
                                        <h4 data-animation="fadeInUp" data-delay="1s"><?php echo $items['subtitle']; ?></h4>
                                        <h1 class="mb-xl-5 mb-4" data-animation="fadeInUp" data-delay="1.3s"><?php echo $items['title']; ?></h1>
                                        <div class="btn-wrap pt-4">
                                            <a href="<?php echo $items['btn_url']; ?>" class="btn-one-white mt-50" data-animation="fadeInUp"
                                            data-delay="1.8s"><span><?php echo $items['btn_text']; ?></span> <i
                                                class="fa-solid fa-angles-right"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
            <div class="banner-five__arry-btn">
                <button class="arry-prev mb-15 banner-five__arry-prev"><i class="fa-light fa-chevron-left"></i></button>
                <button class="arry-next banner-five__arry-next"><i class="fa-light fa-chevron-right"></i></button>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Banner_Three_Widget());