<?php
/**
 * Elementor Widget
 * @package Exgrid
 * @since 1.0.0
 */

namespace Elementor;
class Exgrid_Accordion_List extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'exgrid-accordion-list-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Accordion list', 'exgrid-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['exgrid_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'exgrid-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'exgrid-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'exgrid-core'),
                'default' => esc_html__('User Research', 'exgrid-core')
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('content', 'exgrid-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'exgrid-core'),
                'default' => esc_html__('To deliver the best experience, we thoroughly research and evaluate your product and its users to create a strategic foundation for the brand.', 'exgrid-core')
            ]
        );
        $this->add_control('accordion_list_items', [
            'label' => esc_html__('Accordion list Item', 'exgrid-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);
        $this->end_controls_section();


        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Tab Settings', 'exgrid-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $accordion_list_items = $settings['accordion_list_items'];
        ?>

        <div class="accordion" id="accordionExample-two">
            <?php $i = 1; foreach ($accordion_list_items as $item): ?>
                <?php
                    $j = '';
                    $k = '';
                    if($i < 2) {
                        $j = 'show';
                        $k = 'collapsed';
                    }else {
                        $k = '';
                    }
                ?>
                <div class="accordion-item wow fadeInDown" data-wow-duration="1.2s"
                    data-wow-delay=".<?php echo $i; ?>s">
                    <h2 class="accordion-header" id="heading<?php echo $i; ?>">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse<?php echo $i; ?>">
                            <?php echo $item['title']; ?>
                        </button>
                    </h2>
                    <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $j; ?>"
                        aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#accordionExample-two">
                        <div class="accordion-body">
                            <p><?php echo $item['content']; ?></p>
                        </div>
                    </div>
                </div>
            <?php $i++; endforeach; ?>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Exgrid_Accordion_List());