<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_About_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-about-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('About two', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('main_img',
            [
                'label' => esc_html__('Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('main_img_2',
            [
                'label' => esc_html__('main img 2', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('box_img_1',
            [
                'label' => esc_html__('box img 1', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('25', 'foresty-core')
            ]
        );
        $this->add_control('content',
            [
                'label' => esc_html__('content', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Years Experience', 'foresty-core')
            ]
        );
        $this->add_control('time',
            [
                'label' => esc_html__('time', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('SINCE 1980', 'foresty-core')
            ]
        );
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <div class="about-two__image">
            <img src="<?php echo $settings['main_img']['url']; ?>" alt="image">
            <div class="sm-image d-none d-sm-block">
                <img src="<?php echo $settings['main_img_2']['url']; ?>" alt="image">
            </div>
            <div class="info d-none d-sm-block bg-image" style="background-image: url('<?php echo $settings['box_img_1']['url']; ?>');">
                <h2><span class="count"><?php echo $settings['title']; ?></span>+</h2>
                <span class="year"><?php echo $settings['content']; ?></span>
            </div>
            <div class="stroke-text d-none d-sm-block">
                <h2><?php echo $settings['time']; ?></h2>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_About_Two_Widget());