<?php
/**
 * Theme Custom Post Type(CPTs)
 * @package Foresty
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}

if (!class_exists('Foresty_Custom_Post_Type')) {
    class Foresty_Custom_Post_Type
    {

        //$instance variable
        private static $instance;

        public function __construct()
        {
            //register post type
            add_action('init', array($this, 'register_custom_post_type'));
        }

        /**
         * get Instance
         * @since  2.0.0
         */
        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        /**
         * Register Custom Post Type
         * @since  2.0.0
         */
        public function register_custom_post_type()
        {
            if (!defined('ELEMENTOR_VERSION')) {
                return;
            }
            $all_post_type = array(
                [
                    'post_type' => 'service',
                    'args' => array(
                        'label' => esc_html__('Service', 'foresty-core'),
                        'description' => esc_html__('Service', 'foresty-core'),
                        'labels' => array(
                            'name' => esc_html_x('Service', 'Post Type General Name', 'foresty-core'),
                            'singular_name' => esc_html_x('Service', 'Post Type Singular Name', 'foresty-core'),
                            'menu_name' => esc_html__('Service', 'foresty-core'),
                            'all_items' => esc_html__('Service', 'foresty-core'),
                            'view_item' => esc_html__('View Service', 'foresty-core'),
                            'add_new_item' => esc_html__('Add New Service', 'foresty-core'),
                            'add_new' => esc_html__('Add New Service', 'foresty-core'),
                            'edit_item' => esc_html__('Edit Service', 'foresty-core'),
                            'update_item' => esc_html__('Update Service', 'foresty-core'),
                            'search_items' => esc_html__('Search Service', 'foresty-core'),
                            'not_found' => esc_html__('Not Found', 'foresty-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'foresty-core'),
                            'featured_image' => esc_html__('Service Image', 'foresty-core'),
                            'remove_featured_image' => esc_html__('Remove Service Image', 'foresty-core'),
                            'set_featured_image' => esc_html__('Set Service Image', 'foresty-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'foresty_theme_options',
                        "rewrite" => array('slug' => 'all-service', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
                [
                    'post_type' => 'project',
                    'args' => array(
                        'label' => esc_html__('Project', 'foresty-core'),
                        'description' => esc_html__('Project', 'foresty-core'),
                        'labels' => array(
                            'name' => esc_html_x('Project', 'Post Type General Name', 'foresty-core'),
                            'singular_name' => esc_html_x('Project', 'Post Type Singular Name', 'foresty-core'),
                            'menu_name' => esc_html__('Project', 'foresty-core'),
                            'all_items' => esc_html__('Project', 'foresty-core'),
                            'view_item' => esc_html__('View Project', 'foresty-core'),
                            'add_new_item' => esc_html__('Add New Project', 'foresty-core'),
                            'add_new' => esc_html__('Add New Project', 'foresty-core'),
                            'edit_item' => esc_html__('Edit Project', 'foresty-core'),
                            'update_item' => esc_html__('Update Project', 'foresty-core'),
                            'search_items' => esc_html__('Search Project', 'foresty-core'),
                            'not_found' => esc_html__('Not Found', 'foresty-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'foresty-core'),
                            'featured_image' => esc_html__('Project Image', 'foresty-core'),
                            'remove_featured_image' => esc_html__('Remove Project Image', 'foresty-core'),
                            'set_featured_image' => esc_html__('Set Project Image', 'foresty-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'foresty_theme_options',
                        "rewrite" => array('slug' => 'all-project', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
                [
                    'post_type' => 'team',
                    'args' => array(
                        'label' => esc_html__('team', 'foresty-core'),
                        'description' => esc_html__('team', 'foresty-core'),
                        'labels' => array(
                            'name' => esc_html_x('Team', 'Post Type General Name', 'foresty-core'),
                            'singular_name' => esc_html_x('Team', 'Post Type Singular Name', 'foresty-core'),
                            'menu_name' => esc_html__('Teams', 'foresty-core'),
                            'all_items' => esc_html__('Teams', 'foresty-core'),
                            'view_item' => esc_html__('View Teams', 'foresty-core'),
                            'add_new_item' => esc_html__('Add New Team Member', 'foresty-core'),
                            'add_new' => esc_html__('Add New Team Member', 'foresty-core'),
                            'edit_item' => esc_html__('Edit Team', 'foresty-core'),
                            'update_item' => esc_html__('Update Team', 'foresty-core'),
                            'search_items' => esc_html__('Search Team', 'foresty-core'),
                            'not_found' => esc_html__('Not Found', 'foresty-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'foresty-core'),
                            'featured_image' => esc_html__('Team Image', 'foresty-core'),
                            'remove_featured_image' => esc_html__('Remove Team Image', 'foresty-core'),
                            'set_featured_image' => esc_html__('Set Team Image', 'foresty-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'foresty_theme_options',
                        "rewrite" => array('slug' => 'all-team', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ]
            );

            if (!empty($all_post_type) && is_array($all_post_type)) {

                foreach ($all_post_type as $post_type) {
                    call_user_func_array('register_post_type', $post_type);
                }
            }


            /**
             * Custom Taxonomy Register
             * @since 1.0.0
             */

            $all_custom_taxonmy = array(
                array(
                    'taxonomy' => 'service-cat',
                    'object_type' => 'service',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Service Category", 'foresty-core'),
                            "singular_name" => esc_html__("Service Category", 'foresty-core'),
                            "menu_name" => esc_html__("Service Category", 'foresty-core'),
                            "all_items" => esc_html__("All Service Category", 'foresty-core'),
                            "add_new_item" => esc_html__("Add New Service Category", 'foresty-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'service-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'project-cat',
                    'object_type' => 'project',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Project Category", 'foresty-core'),
                            "singular_name" => esc_html__("Project Category", 'foresty-core'),
                            "menu_name" => esc_html__("Project Category", 'foresty-core'),
                            "all_items" => esc_html__("All Project Category", 'foresty-core'),
                            "add_new_item" => esc_html__("Add New Project Category", 'foresty-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'project-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'team-cat',
                    'object_type' => 'team',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Team Category", 'foresty-core'),
                            "singular_name" => esc_html__("Team Category", 'foresty-core'),
                            "menu_name" => esc_html__("Team Category", 'foresty-core'),
                            "all_items" => esc_html__("All Team Category", 'foresty-core'),
                            "add_new_item" => esc_html__("Add New Team Category", 'foresty-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'team-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                )
            );

            if (is_array($all_custom_taxonmy) && !empty($all_custom_taxonmy)) {
                foreach ($all_custom_taxonmy as $taxonomy) {
                    call_user_func_array('register_taxonomy', $taxonomy);
                }
            }


            /**
             * Custom Tags Register
             * @since 1.0.0
             */

            $all_custom_tags = array(
                array(
                    'taxonomy' => 'service-tag',
                    'object_type' => 'service',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Service Tag", 'foresty-core'),
                            "singular_name" => esc_html__("Service Tag", 'foresty-core'),
                            "menu_name" => esc_html__("Service Tag", 'foresty-core'),
                            "all_items" => esc_html__("All Service Tag", 'foresty-core'),
                            "add_new_item" => esc_html__("Add New Service Tag", 'foresty-core')
                        ),
                        "public" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'service-tag'),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                        'hierarchical' => false,
                        'update_count_callback' => '_update_post_term_count',
                    )
                ),
                array(
                    'taxonomy' => 'project-tag',
                    'object_type' => 'project',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Project Tag", 'foresty-core'),
                            "singular_name" => esc_html__("Project Tag", 'foresty-core'),
                            "menu_name" => esc_html__("Project Tag", 'foresty-core'),
                            "all_items" => esc_html__("All Project Tag", 'foresty-core'),
                            "add_new_item" => esc_html__("Add New Project Tag", 'foresty-core')
                        ),
                        "public" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'project-tag'),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                        'hierarchical' => false,
                        'update_count_callback' => '_update_post_term_count',
                    )
                ),
                array(
                    'taxonomy' => 'team-tag',
                    'object_type' => 'team',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Team Tag", 'foresty-core'),
                            "singular_name" => esc_html__("Team Tag", 'foresty-core'),
                            "menu_name" => esc_html__("Team Tag", 'foresty-core'),
                            "all_items" => esc_html__("All Team Tag", 'foresty-core'),
                            "add_new_item" => esc_html__("Add New Team Tag", 'foresty-core')
                        ),
                        "public" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'team-tag'),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                        'hierarchical' => false,
                        'update_count_callback' => '_update_post_term_count',
                    )
                ),
            );

            if (is_array($all_custom_tags) && !empty($all_custom_tags)) {
                foreach ($all_custom_tags as $tags) {
                    call_user_func_array('register_taxonomy', $tags);
                }
            }


            flush_rewrite_rules();
        }

    }//end class

    if (class_exists('Foresty_Custom_Post_Type')) {
        Foresty_Custom_Post_Type::getInstance();
    }
}